<?php 
/*
Plugin Name: Chariton Master
Plugin URI: https://ifingerstudio.com/chariton/
Description: After install the Chariton Theme, you must need to install "Chariton Master" plugin first to get all features.
Author: Johanspond
Author URI: https://themeforest.net/user/johanspond
Version: 2.0.7
Text Domain: chariton
Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

//define
define( 'CHARITON_VERSION', '2.0.7' );
define( 'CHARITON_PLG_URL', plugin_dir_url( __FILE__ ) );
define( 'CHARITON_PLG_DIR', dirname( __FILE__ ) );
define( 'CHARITON_PLG_DEMO_PATH', dirname( __FILE__ ) . '/demo-importer/' );
define( 'CHARITON_PLG_DEMO_URL', plugin_dir_url( __FILE__ ) . 'demo-importer/' );


# load plugin textdomain
function chariton_master_load_textdomain(){
	load_plugin_textdomain('chariton', false, dirname(plugin_basename( __FILE__ )) . '/languages/');
}
add_action('plugins_loaded', 'chariton_master_load_textdomain');


/*------------------------------------------------------------------------------------------------------------------*/
/*  Plugin required file include.
/*------------------------------------------------------------------------------------------------------------------*/
require_once CHARITON_PLG_DIR . '/inc/helper.php';
require_once CHARITON_PLG_DIR . '/inc/enqueue.php';
require_once CHARITON_PLG_DIR . '/inc/post-like.php';
require_once CHARITON_PLG_DIR . '/inc/style-functions.php';
require_once CHARITON_PLG_DIR . '/inc/custom-style.php';
require_once CHARITON_PLG_DIR . '/inc/custom-widgets.php';
require_once CHARITON_PLG_DIR . '/inc/custom-posttype.php';

/**  theme option framework.
--------------------------------------------------------------------------------------------------- */
require_once CHARITON_PLG_DIR . '/framework/chariton-framework.php';


/** Chariton Modules.
--------------------------------------------------------------------------------------------------- */
require_once CHARITON_PLG_DIR . '/chariton-elements/chariton-elements.php';

require_once CHARITON_PLG_DIR . '/demo-importer/import.php';