<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings           = array(
  'menu_title'      => __( 'Chariton Options', 'chariton' ),
  'menu_type'       => 'menu', // menu, submenu, options, theme, etc.
  'menu_slug'       => 'chariton',
  'ajax_save'       => false,
  'show_reset_all'  => false,
  'framework_title' => __( 'Chariton', 'chariton' ),
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options        = array();


// ===================================================================
// Genaral Settings =
// ===================================================================

$options[]      = array(
  'name'        => 'genaral',
  'title'       => __( 'Genaral Settings', 'chariton' ),
  'icon'        => 'fal fa-home-heart',
  'sections' => array(

    // Logo & Site Icon
    array(
      'name'     => 'logo_and_site_icon',
      'title'    => 'Logo & Icon Settings',
      'icon'     => 'fa fa-plus',
      'fields'   => array(

        array(
          'type'    => 'heading',
          'content' => __( 'Site Icon Settings', 'chariton' ),
        ),
        array(
          'id'          => 'chariton_site_icon',
          'type'        => 'image',
          'title'       => __( 'Upload Favicon Icon', 'chariton' ),
          'default'     => CHARITON_PLG_URL. 'assets/imgs/favicon.png',
          'desc'       => __( 'Site Favicon Icons should be square and Recommended size is 32 × 32 pixels.', 'chariton' ),
        ),
        array(
          'type'    => 'heading',
          'content' => __( 'Logo Settings', 'chariton' ),
        ),
        array(
          'id'          => 'chariton_logo_img',
          'type'        => 'image',
          'title'       => __( 'Upload Default Logo', 'chariton' ),
          'default'     => CHARITON_PLG_URL. 'assets/imgs/logo.png',
          'desc'       => __( 'Recommended image size is 238x70 png file', 'chariton' ),
        ),
        array(
          'id'          => 'chariton_sticky_logo_img',
          'type'        => 'image',
          'title'       => __( 'Upload Default Sticky Logo', 'chariton' ),
          'default'     => CHARITON_PLG_URL. 'assets/imgs/logo.png',
          'desc'       => __( 'Recommended image size is 238x70 png file', 'chariton' ),
        ),
        array(
          'id'       => 'chariton_logo_width',
          'type'     => 'text',
          'title'    => __( 'Logo Custom Width', 'chariton' ),
          'default'  => '238px',
          'desc'       => __( 'Adjust your logo size.', 'chariton' ),
        ),
        array(
          'id'          => 'chariton_logo2_img',
          'type'        => 'image',
          'title'       => __( 'Upload Header 4 Responsive Logo', 'chariton' ),
          'default'     => CHARITON_PLG_URL. 'assets/imgs/logo2.png',
          'desc'     => __( 'Recommended image size is 238x70 png file', 'chariton' ),
        ),
        array(
          'id'      => 'h4logo_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Header 4 Logo Background Color', 'chariton' ),
          'default' => '#33bbb0',
          'desc'     => __( 'Pick Color', 'chariton' ),
        ),

      ),
    ),

    // Breadcrumb Settings
    array(
      'name'     => 'breadcrumb_settings',
      'title'    => 'Breadcrumb Settings',
      'icon'     => 'fa fa-plus',
      'fields'   => array(

        array(
          'type'       => 'heading',
          'content'    => __( 'Breadcrumb Settings', 'chariton' ),
        ),

        array(
          'id'           => 'chariton_breadcrumb_switch',
          'type'         => 'switcher',
          'title'        => __( 'Breadcrumb On/Off', 'chariton' ),
          'desc'          => __( 'On/Off Site Breadcrumb.', 'chariton' ),
          'default'      => true,
        ),
        array(
          'id'      => 'breadcrumb_bg_condition',
          'type'    => 'select',
          'title'   => __( 'Select Background image/color', 'chariton' ),
          'options'      => array(
            '0'     => 'Select banckground',
            'image' => 'Image',
            'color' => 'Color',
          ),
          'desc'          => __( 'Select breadcrumb type image or color.', 'chariton' ),
        ),
        array(
          'id'      => 'breatcrumb_bg_img',
          'type'    => 'image',
          'title'   => __( 'Breadcrumb Background Image', 'chariton' ),
          'desc'       => __( 'Recommended image size is 1920x400 jpg/png file, for secondary header', 'chariton' ),
          'dependency'   => array( 'breadcrumb_bg_condition', '==', 'image' ),
        ),
        array(
          'id'      => 'breadcrumb_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Breadcrumb background color', 'chariton' ),
          'desc'          => __( 'Choose breadcrumb background color.', 'chariton' ),
          'default' => '#000927',
          'dependency'   => array( 'breadcrumb_bg_condition', '!=', 'image' ),
        ),
        array(
          'id'      => 'breatcrumb_pt',
          'type'    => 'text',
          'title'   => __( 'Breadcrumb padding top', 'chariton' ),
          'desc'          => __( 'Breadcrumb padding top with px ( like as 150px ).', 'chariton' ),
          'default' => '135px',
        ),
        array(
          'id'      => 'breatcrumb_pb',
          'type'    => 'text',
          'title'   => __( 'Breadcrumb padding bottom', 'chariton' ),
          'desc'          => __( 'Breadcrumb padding bottom with px ( like as 150px ).', 'chariton' ),
          'default' => '135px',
        ),
        array(
          'id'        => 'chariton_breadcrumb_font_size',
          'type'      => 'text',
          'title'     => __( 'Breadcrumb font size', 'chariton' ),
          'default'   => '80px',
          'desc'      => __( 'Choose breadcrumb font size.', 'chariton' ),
        ),
        array(
          'id'             => 'chariton_breadcrumb_font_weight',
          'type'           => 'select',
          'title'          => 'Breadcrumb Font Weight',
          'desc'           => __( 'Choose default breadcrumb font weight', 'chariton' ),
          'class'          => 'chosen',
          'options'        => array(
            '500'        => '500',
            '600'        => '600',
            '400'        => '400',
            '300'        => '300',
          ),
          'attributes'     => array(
            'style'        => 'width: 150px;'
          ),
        ),
        array(
          'id'             => 'chariton_breadcrumb_text_transform',
          'type'           => 'select',
          'title'          => 'Breadcrumb Text Transform',
          'desc'           => __( 'Choose default breadcrumb text transform', 'chariton' ),
          'class'          => 'chosen',
          'options'        => array(
            'capitalize'   => 'Capitalized',
            'lowercase'    => 'Lowercase',
            'uppercase'    => 'Uppercase',
            'unset'        => 'Default',
          ),
          'attributes'     => array(
            'style'        => 'width: 150px;'
          ),
        ),
        array(
          'id'            => 'breatcrumb_font_color',
          'type'          => 'color_picker',
          'title'         => __( 'Breadcrumb font color', 'chariton' ),
          'desc'          => __( 'Choose breadcrumb font color.', 'chariton' ),
          'default'       => '#fff',
        ),
        array(
          'id'            => 'breatcrumb_hover_link_color',
          'type'          => 'color_picker',
          'title'         => __( 'Breadcrumb hover link color', 'chariton' ),
          'desc'          => __( 'Choose breadcrumb link hover color.', 'chariton' ),
          'default'       => '#ff566e',
        ),
        array(
          'id'            => 'breadcrumb_overlay_color',
          'type'          => 'color_picker',
          'title'         => __( 'Breadcrumb overlay color', 'chariton' ),
          'desc'          => __( 'Choose breadcrumb overlay color.', 'chariton' ),
          'default'       => '#39537E',
          'dependency'    => array( 'breadcrumb_bg_condition', '==', 'image' ),
        ),
        array(
          'id'            => 'breadcrumb_bg_img_opacity',
          'type'          => 'select',
          'title'         => __( 'Breadcrumb Background Image Opacity', 'chariton' ),
          'options'       => array(
            '0'   => '0',
            '0.2' => '0.2',
            '0.3' => '0.3',
            '0.4' => '0.4',
            '0.5' => '0.5',
            '0.6' => '0.6',
            '0.7' => '0.7',
            '0.8' => '0.8',
            '0.9' => '0.9',
            '1'   => '1',
          ),
          'dependency'    => array( 'breadcrumb_bg_condition', '==', 'image' ),
          'desc'          => __( 'Select breadcrumb overlay Opacity.', 'chariton' ),
        ),

      ),
    ),

    array(
      'name'     => 'site_preloader_settings',
      'title'    => 'Preloader Settings',
      'icon'     => 'fa fa-plus',
      'fields'   => array(

        array(
          'type'    => 'heading',
          'content' => __( 'Chariton Switcher Settings', 'chariton' ),
        ),
        array(
          'type'    => 'subheading',
          'content' => __( 'Page Loader', 'chariton' ),
        ),
        array(
          'id'           => 'chariton_preloader_enable',
          'type'         => 'switcher',
          'title'        => __( 'Preloader on?', 'chariton' ),
          'default'      => true,
          'desc'         => __( 'On/Off site preloader.', 'chariton' ),
        ),
        array(
          'id'            => 'chariton_preloader_color',
          'type'          => 'color_picker',
          'title'         => __( 'Preloader Color', 'chariton' ),
          'desc'          => __( 'Pick Preloader Color.', 'chariton' ),
          'default'       => '#00ffa8',
        ),
        array(
          'id'            => 'chariton_preloader_bg_color',
          'type'          => 'color_picker',
          'title'         => __( 'Preloader Background Color', 'chariton' ),
          'desc'          => __( 'Pick Preloader Background Color.', 'chariton' ),
          'default'       => '#000d38',
        ),
        array(
          'type'          => 'subheading',
          'content'       => __( 'Scroll to top', 'chariton' ),
        ),
        array(
          'id'           => 'chariton_scroll_top',
          'type'         => 'switcher',
          'default'      => true,
          'title'        => __( 'Scroll Top On?', 'chariton' ),
          'desc'         => __( 'On/Off Scroll Top Button.', 'chariton' ),
        ),
        array(
          'id'           => 'chariton_scroll_top_bg_color',
          'type'         => 'color_picker',
          'title'        => __( 'Scroll Top Background Color', 'chariton' ),
          'desc'         => __( 'Choose scroll to top background color.', 'chariton' ),
          'default'      => '#39bdb2',
        ),
        array(
          'id'            => 'chariton_scroll_top_font_color',
          'type'          => 'color_picker',
          'title'         => __( 'Scroll Top Font Color', 'chariton' ),
          'desc'          => __( 'Choose scroll to top font color.', 'chariton' ),
          'default'       => '#ffffff',
        ),

      ),
    ),

  )
);


// ===================================================================
// Typography Settings =
// ===================================================================

$options[]      = array(
  'name'        => 'chariton_typography',
  'title'       => __( 'Typography Settings', 'chariton' ),
  'icon'        => 'fal fa-text-height',
   // begin: fields
  'fields'      => array(

    array(
      'type'    => 'heading',
      'content' => __( 'Site Font Settings', 'chariton' ),
    ),
    array(
      'id'           => 'chariton_body_font',
      'type'         => 'typography',
      'title'        => __( 'Body Font Family', 'chariton' ),
      'default'   => array(
        'family'  => 'Karla',
        'font'    => 'google', // this is helper for output ( google, websafe, custom )
      ),
      'variant'   => false,
      'desc'      => __( 'Select website body font family.', 'chariton' ),
    ),
    array(
      'id'        => 'chariton_body_font_size',
      'type'      => 'text',
      'title'     => __( 'Body font size', 'chariton' ),
      'default'   => '16px',
      'desc'      => __( 'Select website body font size.', 'chariton' ),
    ),
    array(
      'id'        => 'line_height',
      'type'      => 'text',
      'title'     => __( 'Text Line Height', 'chariton' ),
      'default'   => '26px',
      'desc'      => __( 'Choose body font line height.', 'chariton' ),
    ),

    array(
      'id'           => 'chariton_heading_font',
      'type'         => 'typography',
      'title'        => __( 'Heading Font Family', 'chariton' ),
      'default'   => array(
        'family'  => 'Barlow Condensed',
        'font'    => 'google', // this is helper for output ( google, websafe, custom )
      ),
      'variant'   => false,
      'desc'      => __( 'Select website heading font family.', 'chariton' ),
    ),

    
    array(
      'type'    => 'heading',
      'content' => __( 'Site Color Setting', 'chariton' ),
    ),
    array(
      'id'      => 'chariton_base_color',
      'type'    => 'color_picker',
      'title'   => __( 'Theme Base Color', 'chariton' ),
      'default' => '#39bdb2',
      'desc'    => __( 'Choose your theme base color.', 'chariton' ),
    ),
    array(
      'id'      => 'chariton_base_color2',
      'type'    => 'color_picker',
      'title'   => __( 'Theme Base Color Two', 'chariton' ),
      'desc'    => __( 'Choose your theme base color two.', 'chariton' ),
      'default' => '#ff4b57',
    ),
  
  )
);



// ===================================================================
// Header Settings =
// ===================================================================
$options[]   = array(
  'name'     => 'header_setting',
  'title'    => __( 'Header Settings', 'chariton' ),
  'icon'     => 'fal fa-heading',
  'sections' => array(

    // Header top part 1
    array(
      'name'     => 'header_one',
      'title'    => 'Header 1',
      'icon'     => 'fal fa-plus',
      'fields'   => array(

        array(
          'type'    => 'heading',
          'content' =>  __( 'Header One Elements Settings', 'chariton' ),
        ),

        array(
          'id'      => 'top_header',
          'type'    => 'switcher',
          'default' => true,
          'title'   =>  __( 'Header Top Part On?', 'chariton' ),
          'desc'   => 'On/Off Header Top Part',
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Header Top Part Color', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'      => 'htop_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Menu Background Color', 'chariton' ),
          'default' => '#ffffff',
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'      => 'htop_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top Header Color 1', 'chariton' ),
          'default' => '#5b7d9a',
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'      => 'htop_font_color2',
          'type'    => 'color_picker',
          'title'   => __( 'Top Header Color 2', 'chariton' ),
          'default' => '#ff566e',
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'      => 'htop_hover_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top header link hover color', 'chariton' ),
          'default' => '#ff566e',
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),

        array(
          'type'    => 'subheading',
          'content' =>  __( 'Header Top language', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'              => 'header_language',
          'type'            => 'textarea',
          'title'           =>  __( 'Language Shortcode', 'chariton' ),
          'shortcode'   => true,
          'default'     => '[charitonlang]',
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),

        array(
          'type'    => 'subheading',
          'content' =>  __( 'Header Top Contact Info', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'              => 'header_contact_list',
          'type'            => 'group',
          'title'           =>  __( 'Header Top Contact Info List', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
          'button_title'    =>  __( 'Add New', 'chariton' ),
          'accordion_title' =>  __( 'Add New Field', 'chariton' ),
          'fields'        => array(
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     =>  __( 'Title' ),
            ),
            array(
              'id'        => 'info_text',
              'type'      => 'text',
              'title'     =>  __( 'Info Text' ),
            ),
          ),
          'default'   => array(
            array(
              'title'         => 'Mail Us',
              'info_text'     => 'info@webmail.com',
            ),
            array(
              'title'         => 'Call Us',
              'info_text'     => '878 767 876 567',
            ),
          ),
        ),

        array(
          'type'    => 'subheading',
          'content' =>  __( 'Header Top Social Buttons', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'              => 'header_social_btn',
          'type'            => 'group',
          'title'           =>  __( 'Header Top Social Button', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
          'button_title'    =>  __( 'Add New', 'chariton' ),
          'accordion_title' =>  __( 'Add New Field', 'chariton' ),
          'fields'          => array(
            array(
              'id'          => 'social_icon',
              'type'        => 'icon',
              'title'       =>  __( 'Social Icon' ),
            ),
            array(
              'id'          => 'social_link',
              'type'        => 'text',
              'title'       =>  __( 'Link' ),
            ),
          ),

          'default'   => array(
            array(
              'social_icon'          => 'fab fa-facebook-f',
              'social_link'         => '#',
            ),
            array(
              'social_icon'          => 'fab fa-twitter',
              'social_link'         => '#',
            ),
            array(
              'social_icon'          => 'fab fa-behance',
              'social_link'         => '#',
            ),
            array(
              'social_icon'          => 'fab fa-instagram',
              'social_link'         => '#',
            ),
            array(
              'social_icon'          => 'fab fa-youtube',
              'social_link'         => '#',
            ),
          ),
        ),
        array(
          'id'      => 'header_social_icons_color',
          'type'    => 'color_picker',
          'dependency'   => array( 'top_header', '==', 'true' ),
          'title'   => __( 'Header Social Icon Color', 'chariton' ),
          'after'   => '<p class="cs-text-muted">Header social icon color.</p>',
          'default' => '#5b7d9a',
        ),
        array(
          'type'    => 'subheading',
          'content' =>  __( 'Header Top Right Menu', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'              => 'header_menu_list',
          'type'            => 'group',
          'title'           =>  __( 'Header Top Right Menu', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
          'button_title'    =>  __( 'Add New', 'chariton' ),
          'accordion_title' =>  __( 'Add New Field', 'chariton' ),
          'fields'          => array(
            array(
              'id'          => 'menu_name',
              'type'        => 'text',
              'title'       =>  __( 'Menu name' ),
            ),
            array(
              'id'          => 'menu_link',
              'type'        => 'text',
              'title'       =>  __( 'Link' ),
            ),
          ),
          'default'   => array(
            array(
              'menu_name'         => 'Refund Policy',
              'menu_link'         => '#',
            ),
            array(
              'menu_name'         => 'Payment Options',
              'menu_link'         => '#',
            ),
          ),
        ),

        array(
          'type'    => 'subheading',
          'content' =>  __( 'Header Top Responsive Settings', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'      => 'top_header_responsive_device',
          'type'    => 'switcher',
          'title'   =>  __( 'Small Devices On?', 'chariton' ),
          'desc'   => 'On/Off header top part on mobile or tablet devices.',
        ),
        array(
          'id'      => 'top_header_medium_rs_device',
          'type'    => 'switcher',
          'title'   =>  __( 'Medium Devices On?', 'chariton' ),
          'desc'   => 'On/Off header top part on medium devices.',
        ),

      )
    ),

    // Header top part 2
    array(
      'name'     => 'header_four',
      'title'    => 'Header 4',
      'icon'     => 'fal fa-plus',
      'fields'   => array(

        array(
          'type'    => 'heading',
          'content' =>  __( 'Header Four Elements Setting', 'chariton' ),
        ),

        array(
          'id'      => 'top_header4',
          'type'    => 'switcher',
          'default' => true,
          'title'   =>  __( 'Header Top Part On?', 'chariton' ),
          'desc'   => 'It work only for header version 1',
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Header Top Part Color', 'chariton' ),
        ),
        array(
          'id'      => 'h4top_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Background color', 'chariton' ),
          'default' => '#061738',
        ),
        array(
          'id'      => 'h4top_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top header color', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'h4top_icon_border_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top header icon border color', 'chariton' ),
          'default' => '#122750',
        ),
        array(
          'id'      => 'h4top_link_hover_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top header link hover color', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'h4top_icon_hover_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top header link hover background color', 'chariton' ),
          'default' => '#33bbb0',
        ),

        array(
          'type'    => 'subheading',
          'content' =>  __( 'Header 4 Elements Setting', 'chariton' ),
        ),
        array(
          'id'              => 'header4_contact_list',
          'type'            => 'group',
          'title'           =>  __( 'Header contact info list', 'chariton' ),
          'button_title'    =>  __( 'Add New', 'chariton' ),
          'accordion_title' =>  __( 'Add New Field', 'chariton' ),
          'fields'          => array(
            array(
              'id'          => 'title',
              'type'        => 'text',
              'title'       =>  __( 'Title' ),
            ),
            array(
              'id'          => 'info_text',
              'type'        => 'text',
              'title'       =>  __( 'Info text' ),
            ),
            array(
              'id'          => 'icon',
              'type'        => 'icon',
              'title'       =>  __( 'Icon' ),
            ),
          ),
          'default'   => array(
            array(
              'title'         => 'Email Address',
              'info_text'     => 'info@webmail.com',
              'icon'          => 'far fa-envelope',
            ),
            array(
              'title'         => 'Phone Number',
              'info_text'     => '+098 7875 764 753',
              'icon'          => 'fal fa-phone',
            ),
          ),
        ),
        // array(
        //   'id'      => 'top_header4_search',
        //   'type'    => 'switcher',
        //   'title'   =>  __( 'Header 4 Search Disable?', 'chariton' ),
        //   'default' => true,
        //   'desc'   => 'It want to disable header 4 search bar, please off it',
        //   'dependency'      => array( 'top_header4', '==', 'true' ),
        // ),
        // array(
        //   'type'    => 'subheading',
        //   'content' => __( 'Off Canvas Menu Settings', 'chariton' ),
        //   'dependency'      => array( 'top_header4', '==', 'true' ),
        // ),

        array(
          'type'    => 'subheading',
          'content' =>  __( 'Header Top Responsive Settings', 'chariton' ),
          'dependency'   => array( 'top_header', '==', 'true' ),
        ),
        array(
          'id'      => 'top_header4_medium_rs_device',
          'type'    => 'switcher',
          'title'   =>  __( 'Medium Devices On?', 'chariton' ),
          'desc'   => 'On/Off header top part on medium devices.',
        ),
        array(
          'id'      => 'top_header_responsive4_device',
          'type'    => 'switcher',
          'title'   =>  __( 'Small Devices On?', 'chariton' ),
          'desc'   => 'On/Off header top part on mobile or tablet devices.',
        ),
        array(
          'id'      => 'top_header_responsive4_es_device',
          'type'    => 'switcher',
          'title'   =>  __( 'Extra Small Devices On?', 'chariton' ),
          'desc'   => 'On/Off header top part on extra small devices.',
        ),

      )
    ),

    // Offcanvas Menu Settings
    array(
      'name'     => 'default_offcanvas_settings',
      'title'    => 'Off Canvas Menu Settings',
      'icon'     => 'fal fa-plus',
      'fields'   => array(
        array(
          'type'    => 'heading',
          'content' => __( 'Off Canvas Menu Settings', 'chariton' ),
        ),
        array(
          'id'      => 'top_header4_toggle',
          'type'    => 'switcher',
          'title'   =>  __( 'Header Off Canvas Menu', 'chariton' ),
          'default' => true,
          'desc'   => 'On/Off Off Canvas Toggle Menu.',
        ),
        array(
          'id'              => 'header4_tm_socials',
          'type'            => 'group',
          'title'           =>  __( 'Header toggle menu socials', 'chariton' ),
          'button_title'    =>  __( 'Add New', 'chariton' ),
          'accordion_title' =>  __( 'Add New Field', 'chariton' ),
          'fields'          => array(
            array(
              'id'          => 'icon',
              'type'        => 'icon',
              'title'       =>  __( 'Icon' ),
            ),
            array(
              'id'          => 'link',
              'type'        => 'text',
              'title'       =>  __( 'Title' ),
            ),
          ),
          'default'   => array(
            array(
              'icon'          => 'fab fa-facebook-f',
              'link'          => '#',
            ),
            array(
              'icon'          => 'fab fa-twitter',
              'link'          => '#',
            ),
            array(
              'icon'          => 'fab fa-behance',
              'link'          => '#',
            ),
            array(
              'icon'          => 'fab fa-instagram',
              'link'          => '#',
            ),
            array(
              'icon'          => 'fab fa-youtube',
              'link'          => '#',
            ),
          ),
        ),
      )
    ),


    // Default Header Settings
    array(
      'name'     => 'default_header_settings',
      'title'    => 'Header Layout Settings',
      'icon'     => 'fal fa-plus',
      'fields'   => array(
        array(
          'type'    => 'heading',
          'content' => __( 'Select Header Layouts', 'chariton' ),
        ),
        array(
          'id'          => 'default_header_style',
          'type'        => 'image_select',
          'title'       => __( 'Select Default Header', 'chariton' ),
          'options'     => array(
            'style1'    => CHARITON_PLG_URL. 'assets/imgs/header1.jpg',
            'style2'    => CHARITON_PLG_URL. 'assets/imgs/header2.jpg',
            'style3'    => CHARITON_PLG_URL. 'assets/imgs/header3.jpg',
            'style4'    => CHARITON_PLG_URL. 'assets/imgs/header4.jpg',
            'style5'    => CHARITON_PLG_URL. 'assets/imgs/header5.jpg',
          ),
          'desc'   => __( 'This is all default page header style if you select','chariton'),
        ),
        array(
          'id'          => 'default_h2_top',
          'type'        => 'text',
          'title'       =>  __( 'Header 2 padding top' ),
          'default'     => '290px',
          'dependency'  => array( 'default_header_style_style2', '==', 'true' ),
          'desc'        => __( 'When select header 2, you need to breadcrumb top padding reset if you feel need', 'chariton' ),
        ),
        array(
          'id'          => 'default_h2_bottom',
          'type'        => 'text',
          'title'       =>  __( 'Header 2 padding bottom' ),
          'default'     => '135px',
          'dependency'  => array( 'default_header_style_style2', '==', 'true' ),
          'desc'        => __( 'When select header 2, you need to breadcrumb bottom padding reset if you feel need', 'chariton' ),
        ),
        array(
          'id'          => 'default_h3_top',
          'type'        => 'text',
          'title'       =>  __( 'Header 3 padding top' ),
          'default'     => '325px',
          'dependency'  => array( 'default_header_style_style3', '==', 'true' ),
          'desc'        => __( 'When select header 3, you need to breadcrumb top padding reset if you feel need', 'chariton' ),
        ),
        array(
          'id'          => 'default_h3_bottom',
          'type'        => 'text',
          'title'       =>  __( 'Header 3 padding bottom' ),
          'default'     => '135px',
          'dependency'  => array( 'default_header_style_style3', '==', 'true' ),
          'desc'        => __( 'When select header 3, you need to breadcrumb bottom padding reset if you feel need', 'chariton' ),
        ),

      )
    ),

  ),
);



// ===================================================================
// Menu Settings =
// ===================================================================
$options[]   = array(
  'name'     => 'chariton_menu',
  'title'    => __( 'Menu Settings', 'chariton' ),
  'icon'     => 'fal fa-bars',
  'sections' => array(

    // Sticky Menu
    array(
      'name'     => 'sticky_menu',
      'title'    => 'Sticky Menu Settings',
      'icon'     => 'fal fa-plus',
      'fields'   => array(
        // Sticky menu
        array(
          'type'    => 'subheading',
          'content' => __( 'Sticky Menu Settings', 'chariton' ),
        ),
        array(
          'id'      => 'sticky_menu_switch',
          'type'    => 'switcher',
          'title'   =>  __( 'Sticky Menu Off?', 'chariton' ),
          'desc'    => __( 'On/Off Sticky Menu.', 'chariton' ),
          'default' =>  true,
        ),
        array(
          'type'    => 'subheading',
          'content' => __( 'Sticky Menu Color Settings', 'chariton' ),
        ),
        array(
          'id'      => 'menu1_sticky_menu_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Menu Background Color', 'chariton' ),
          'desc'    => __( 'Pick Sticky Menu Background Color', 'chariton' ),
          'default' => '#000d38',
        ),
        array(
          'id'      => 'sticky_menu1_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Menu Font Color', 'chariton' ),
          'desc'    => __( 'Pick Sticky Menu Font Color', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'sticky_menu1_hover_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Menu Hover Font Color', 'chariton' ),
          'desc'    => __( 'Pick Sticky Menu Hover Font Color', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'        => 'sticky_menu1_text_font_size',
          'type'      => 'text',
          'title'     => __( 'Menu Font Size', 'chariton' ),
          'default'   => '18px',
          'desc'      => __( 'Pick Sticky Menu Font Size.', 'chariton' ),
        ),
        array(
          'id'             => 'sticky_menu1_text_font_weight',
          'type'           => 'select',
          'title'          => 'Menu Font Weight',
          'desc'           => __( 'Choose Sticky Menu Font Weight', 'chariton' ),
          'class'          => 'chosen',
          'options'        => array(
            '700'        => '700',
            '600'        => '600',
            '500'        => '500',
            '400'        => '400',
            '300'        => '300',
          ),
          'attributes'     => array(
            'style'        => 'width: 150px;'
          ),
        ),
        array(
          'id'             => 'sticky_menu1_text_transform',
          'type'           => 'select',
          'title'          => 'Menu Text Teransform',
          'desc'           => __( 'Select Sticky Menu Text Transform', 'chariton' ),
          'options'        => array(
            'none'          => 'Default',
            'uppercase'    => 'Uppercase',
            'lowercase'    => 'Lowercase',
            'capitalize'   => 'Capitalize',
          ),
          'default'        => 'capitalize',
          'default_option' => 'Text Transform',
        ),

        // Sticky Menu 1 Submenu
        array(
          'type'    => 'subheading',
          'content' => __( 'Sticky DropDown Menu Color Settings', 'chariton' ),
        ),
        array(
          'id'      => 'sticky_submenu1_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Sub Menu Background Color', 'chariton' ),
          'desc'      => __( 'Choose Sticky DropDown Menu Background Color.', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'sticky_submenu1_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Sub Menu Font Color', 'chariton' ),
          'desc'      => __( 'Pick Sticky DropDown Menu Font Color.', 'chariton' ),
          'default' => '#000d38',
        ),
        array(
          'id'      => 'sticky_submenu1_hover_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Sub Menu Hover Font Color', 'chariton' ),
          'desc'      => __( 'Pick Sticky DropDown Menu Hover Font Color.', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'      => 'sticky_submenu1_border_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Sub Menu Border color', 'chariton' ),
          'desc'      => __( 'Pick Sticky DropDown Menu Border Color.', 'chariton' ),
          'default' => '#eceef0',
        ),
        array(
          'id'        => 'sticky_submenu1_font_size',
          'type'      => 'text',
          'title'     => __( 'Sub Menu Font Size', 'chariton' ),
          'default'   => '18px',
          'desc'      => __( 'Pick Dropdown Menu Font Size.', 'chariton' ),
        ),
        array(
          'id'             => 'sticky_submenu1_font_weight',
          'type'           => 'select',
          'title'          => 'Sub Menu Font Weight',
          'desc'           => __( 'Select Dropdown Menu Font Weight', 'chariton' ),
          'class'          => 'chosen',
          'options'        => array(
            '400'        => '400',
            '700'        => '700',
            '600'        => '600',
            '500'        => '500',
            '300'        => '300',
          ),
          'attributes'     => array(
            'style'        => 'width: 150px;'
          ),
        ),
        array(
          'id'             => 'sticky_submenu1_text_transform',
          'type'           => 'select',
          'title'          => 'Sub Menu Text Teransform',
          'desc'           => __( 'Select Dropdown Menu Text Teransform', 'chariton' ),
          'options'        => array(
            'none'          => 'Default',
            'uppercase'     => 'Uppercase',
            'lowercase'     => 'Lowercase',
            'capitalize'    => 'Capitalize',
          ),
          'default'        => 'capitalize',
          'default_option' => 'Text Transform',
        ),

        // Menu 1 Icon
        array(
          'type'    => 'subheading',
          'content' => __( 'Sticky Responsive Menu Settings', 'chariton' ),
        ),
        array(
          'id'      => 'stickyresponsive_menu_icon_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Mobile Menu Icon Color', 'chariton' ),
          'desc'      => __( 'Pick Sticky Mobile Menu Icon Color.', 'chariton' ),
          'default' => '#444444',
        ),


       )
    ),

    // Menu 1
    array(
      'name'     => 'menu_1',
      'title'    => 'Main Menu Settings',
      'icon'     => 'fal fa-plus',
      'fields'   => array(
        array(
          'type'    => 'subheading',
          'content' => __( 'Menu Color Settings', 'chariton' ),
        ),
        array(
          'id'      => 'menu1_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Menu Background Color', 'chariton' ),
          'desc'    => __( 'Pick Menu Background Color', 'chariton' ),
          'default' => '#000d38',
        ),
        array(
          'id'      => 'menu1_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Menu Font Color', 'chariton' ),
          'desc'    => __( 'Pick Menu Font Color', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'menu1_hover_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Menu Hover Font Color', 'chariton' ),
          'desc'    => __( 'Pick Hover Font Color', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'        => 'menu1_text_font_size',
          'type'      => 'text',
          'title'     => __( 'Menu Font Size', 'chariton' ),
          'default'   => '18px',
          'desc'      => __( 'Pick Menu Font Size.', 'chariton' ),
        ),
        array(
          'id'             => 'menu1_text_font_weight',
          'type'           => 'select',
          'title'          => 'Menu Font Weight',
          'desc'           => __( 'Select Menu Font Weight', 'chariton' ),
          'class'          => 'chosen',
          'options'        => array(
            '700'        => '700',
            '600'        => '600',
            '500'        => '500',
            '400'        => '400',
            '300'        => '300',
          ),
          'attributes'     => array(
            'style'        => 'width: 150px;'
          ),
        ),
        array(
          'id'             => 'menu1_text_transform',
          'type'           => 'select',
          'title'          => 'Menu Text Teransform',
          'desc'           => __( 'Select Menu Text Transform', 'chariton' ),
          'options'        => array(
            'none'          => 'Default',
            'uppercase'    => 'Uppercase',
            'lowercase'    => 'Lowercase',
            'capitalize'   => 'Capitalize',
          ),
          'default'        => 'capitalize',
          'default_option' => 'Text Transform',
        ),


        // Menu 1 Submenu
        array(
          'type'    => 'subheading',
          'content' => __( 'Dropdown Menu Color Settings', 'chariton' ),
        ),
        array(
          'id'      => 'submenu1_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Background Color', 'chariton' ),
          'desc'    => __( 'Pick Dropdown Menu Background Color', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'submenu1_color',
          'type'    => 'color_picker',
          'title'   => __( 'Font Color', 'chariton' ),
          'desc'    => __( 'Pick Dropdown Menu Font Color', 'chariton' ),
          'default' => '#000d38',
        ),
        array(
          'id'      => 'submenu1_hover_color',
          'type'    => 'color_picker',
          'title'   => __( 'Hover Font Color', 'chariton' ),
          'desc'    => __( 'Pick Dropdown Menu Hover Font Color', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'      => 'submenu1_border_color',
          'type'    => 'color_picker',
          'title'   => __( 'Border Color', 'chariton' ),
          'desc'    => __( 'Pick Dropdown Menu Border Color', 'chariton' ),
          'default' => '#eceef0',
        ),

        array(
          'id'        => 'submenu1_text_sub_font_size',
          'type'      => 'text',
          'title'     => __( 'Sub Menu Font Size', 'chariton' ),
          'default'   => '18px',
          'desc'      => __( 'Pick Dropdown Menu Font Size.', 'chariton' ),
        ),
        array(
          'id'             => 'submenu1_sub_text_font_weight',
          'type'           => 'select',
          'title'          => 'Sub Menu Font Weight',
          'desc'           => __( 'Select Dropdown Menu Font Weight', 'chariton' ),
          'class'          => 'chosen',
          'options'        => array(
            '400'        => '400',
            '700'        => '700',
            '600'        => '600',
            '500'        => '500',
            '300'        => '300',
          ),
          'attributes'     => array(
            'style'        => 'width: 150px;'
          ),
        ),
        array(
          'id'             => 'submenu1_sub_text_transform',
          'type'           => 'select',
          'title'          => 'Sub Menu Text Teransform',
          'desc'           => __( 'Select Dropdown Menu Text Teransform', 'chariton' ),
          'options'        => array(
            'none'          => 'Default',
            'uppercase'     => 'Uppercase',
            'lowercase'     => 'Lowercase',
            'capitalize'    => 'Capitalize',
          ),
          'default'        => 'capitalize',
          'default_option' => 'Text Transform',
        ),

        // Menu 1 Icon
        array(
          'type'    => 'subheading',
          'content' => __( 'Responsive Menu Settings', 'chariton' ),
        ),
        array(
          'id'      => 'responsive_menu_icon_color',
          'type'    => 'color_picker',
          'title'   => __( 'Responsive Menu Icon Color', 'chariton' ),
          'desc'      => __( 'Pick Sticky Responsive Menu Icon Color.', 'chariton' ),
          'default' => '#444444',
        ),
        array(
          'id'      => 'responsive_mainmenubg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Mobile Menu Background Color', 'chariton' ),
          'desc'      => __( 'Pick Mobile Menu Background Color.', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'      => 'responsive_mainmenutxt_color',
          'type'    => 'color_picker',
          'title'   => __( 'Mobile Menu Text Color', 'chariton' ),
          'desc'      => __( 'Pick Mobile Menu Text Color.', 'chariton' ),
          'default' => '#ffffff',
        ),

        // Search & login
        array(
          'type'    => 'subheading',
          'content' => __( 'Search & Login Button Settings', 'chariton' ),
        ),
        array(
          'id'        => 'header_one_margin_right_size',
          'type'      => 'text',
          'title'     => __( 'Donation Area Maring Right', 'chariton' ),
          'default'   => '130px',
          'desc'      => __( 'Pick donation area margin right size.', 'chariton' ),
        ),        
        array(
          'id'      => 'search_btn_switch',
          'type'    => 'switcher',
          'title'   =>  __( 'Search Button Off?', 'chariton' ),
          'desc'      => __( 'On/Off Search Button.', 'chariton' ),
          'default' =>  true,
        ),
        array(
          'id'      => 'login_btn_switch',
          'type'    => 'switcher',
          'title'   =>  __( 'Login Button Off?', 'chariton' ),
          'desc'      => __( 'On/Off Login Button.', 'chariton' ),
          'default' =>  true,
        ),
        array(
          'id'      => 'menu1_btn_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Background Color', 'chariton' ),
          'desc'      => __( 'Pick Background Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'menu1_btn_border_color',
          'type'    => 'color_picker',
          'title'   => __( 'Border Color', 'chariton' ),
          'desc'    => __( 'Pick Border Color.', 'chariton' ),
          'default' => '#1d2a55',
        ),
        array(
          'id'      => 'menu1_btn_color',
          'type'    => 'color_picker',
          'title'   => __( 'Font Color', 'chariton' ),
          'desc'    => __( 'Pick Font Color.', 'chariton' ),
          'default' => '#b0b5cc',
        ),
        array(
          'id'      => 'menu1_btn_h_color',
          'type'    => 'color_picker',
          'title'   => __( 'Hover Background Color', 'chariton' ),
          'desc'    => __( 'Pick Hover Background Color.', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'      => 'menu1_btn_h_f_color',
          'type'    => 'color_picker',
          'title'   => __( 'Hover Font Color', 'chariton' ),
          'desc'      => __( 'Pick Hover Font Color.', 'chariton' ),
          'default' => '#ffffff',
        ),

        // Donate button
        array(
          'type'    => 'subheading',
          'content' => __( 'Donate Button Settings', 'chariton' ),
        ),
        array(
          'id'      => 'donate_btn_switch',
          'type'    => 'switcher',
          'title'   =>  __( 'Donate Button Off?', 'chariton' ),
          'desc'    => __( 'On/Off Donate Button.', 'chariton' ),
          'default' =>  true,
        ),
        array(
          'id'      => 'donate_btn_text',
          'type'    => 'text',
          'title'   => __( 'Donate Button Text', 'chariton' ),
          'desc'    => __( 'Insert Donate Button Text.', 'chariton' ),
          'default' => 'Make Donation',
        ),
        array(
          'id'      => 'donate_btn_link',
          'type'    => 'text',
          'title'   => __( 'Donate Button Link', 'chariton' ),
          'desc'    => __( 'Insert Donate Button Link.', 'chariton' ),
          'default' => '#',
        ),
        array(
          'id'      => 'donate_btn_icon_switch',
          'type'    => 'switcher',
          'title'   =>  __( 'Donate Button Icon Off?', 'chariton' ),
          'desc'    => __( 'On/Off Donate Button Icon.', 'chariton' ),
          'default' =>  true,
        ),
        array(
          'id'      => 'menu1_donate_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Background Color', 'chariton' ),
          'desc'    => __( 'Pick Background Color.', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'      => 'menu1_donate_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Font Color', 'chariton' ),
          'desc'    => __( 'Pick Font Color.', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'menu1_donate_hf_color',
          'type'    => 'color_picker',
          'title'   => __( 'Hover Font Color', 'chariton' ),
          'desc'    => __( 'Pick Hover Font Color.', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'menu1_donate_hb_color',
          'type'    => 'color_picker',
          'title'   => __( 'Hover Border Color', 'chariton' ),
          'desc'    => __( 'Pick Hover Border Color.', 'chariton' ),
          'default' => '#ffffff',
        ),
      )
    ),

  ),
);



// ===================================================================
// Blog Settings = 
// ===================================================================
$options[]      = array(
  'name'        => 'blog_setting',
  'title'       =>  __( 'Blog Page Settings', 'chariton' ),
  'icon'        => 'fal fa-blog',
   // begin: fields
  'fields'      => array(

    array(
      'type'         => 'heading',
      'content'      =>  __( 'Blog Page Settings', 'chariton' ),
    ),

    array(
      'id'      => 'blog_page_breadcrumb',
      'type'    => 'text',
      'title'   => __( 'Blog Page Breadcrumb Title', 'chariton' ),
      'default' => __( 'Blog Posts', 'chariton' ),
    ),
  
    array(
      'id'           => 'blog_layout',
      'type'         => 'image_select',
      'title'        =>  __( 'Page Layout Style', 'chariton' ),
      'options'      => array(
        'left-sidebar'  => CHARITON_PLG_URL. 'assets/imgs/sidebar_l.jpg',
        'right-sidebar' => CHARITON_PLG_URL. 'assets/imgs/sidebar_r.jpg',
        'full-width'    => CHARITON_PLG_URL. 'assets/imgs/fullwidth.jpg',
        ),
    ),
    array(
      'id'      => 'blog_post_date',
      'type'    => 'switcher',
      'title'   => __( 'Post date meta on?', 'chariton' ),
      'default' => true,
    ),
    array(
      'id'      => 'blog_post_views',
      'type'    => 'switcher',
      'title'   => __( 'Post view meta on?', 'chariton' ),
    ),
    array(
      'id'      => 'blog_post_comments',
      'type'    => 'switcher',
      'title'   => __( 'Post comment meta on?', 'chariton' ),
      'default' => true,
    ),
    array(
      'id'      => 'blog_post_admin',
      'type'    => 'switcher',
      'title'   => __( 'Post meta admin on?', 'chariton' ),
      'default' => true,
    ),
    array(
      'id'      => 'chariton_post_excerpt_length',
      'type'    => 'text',
      'title'   =>  __( 'Blog post content excerpt length', 'chariton' ),
      'default' => '50',
    ),

    array(
      'type'    => 'subheading',
      'content' =>  __( 'Blog Single Page Setting', 'chariton' ),
    ),

    array(
      'id'           => 'blog_single_layout',
      'type'         => 'image_select',
      'title'        =>  __( 'Single Layout Style', 'chariton' ),
      'options'      => array(
        'left-sidebar'  => CHARITON_PLG_URL. 'assets/imgs/sidebar_l.jpg',
        'right-sidebar' => CHARITON_PLG_URL. 'assets/imgs/sidebar_r.jpg',
        'full-width'    => CHARITON_PLG_URL. 'assets/imgs/fullwidth.jpg',
        ),
    ),

    array(
      'id'      => 'blog_single_post_admin',
      'type'    => 'switcher',
      'title'   => __( 'Post meta admin on?', 'chariton' ),
      'default' => true,
    ),
    array(
      'id'      => 'blog_single_post_date',
      'type'    => 'switcher',
      'title'   => __( 'Post meta date on?', 'chariton' ),
      'default' => true,
    ),
    array(
      'id'      => 'blog_single_post_cats',
      'type'    => 'switcher',
      'title'   => __( 'Post categories on?', 'chariton' ),
      'default' => true,
    ),
    array(
      'id'           => 'chariton_post_details_tag_enable',
      'type'         => 'switcher',
      'title'        => __( 'Post details tags On/Off', 'chariton' ),
      'default'      => true,
    ),
    array(
      'id'           => 'chariton_post_details_share_enable',
      'type'         => 'switcher',
      'title'        => __( 'Post details share On/Off', 'chariton' ),
    ),
    array(
      'id'           => 'single_related_post_switch',
      'type'         => 'switcher',
      'title'        => __( 'Post details related post On/Off', 'chariton' ),
    ),
    array(
      'id'         => 'blog_single_related_title',
      'type'       => 'text',
      'title'      => __( 'Related Post Title', 'chariton' ),
      'default'    => __( 'Related Post', 'chariton' ),
      'dependency' => array( 'single_related_post_switch', '==', 'true' ),
    ),
  
  )
);


// ===================================================================
// Give WP Settings = 
// ===================================================================
$options[]      = array(
  'name'        => 'givewp_setting',
  'title'       =>  __( 'Give Donation Settings', 'chariton' ),
  'icon'        => 'fal fa-blog',
   // begin: fields
  'fields'      => array(

    array(
      'type'         => 'heading',
      'content'      =>  __( 'Donation Single Page Setting', 'chariton' ),
    ),

    array(
      'id'           => 'givewp_single_layout',
      'type'         => 'image_select',
      'title'        =>  __( 'Single Layout Style', 'chariton' ),
      'desc'         =>  __( 'Choose Single Donation Page Layout', 'chariton' ),
      'options'      => array(
        'left-sidebar'  => CHARITON_PLG_URL. 'assets/imgs/sidebar_l.jpg',
        'right-sidebar' => CHARITON_PLG_URL. 'assets/imgs/sidebar_r.jpg',
        'full-width'    => CHARITON_PLG_URL. 'assets/imgs/fullwidth.jpg',
        ),
    ),
    array(
      'id'           => 'single_give_author_switch',
      'type'         => 'switcher',
      'title'        => __( 'Author Info On/Off', 'chariton' ),
      'desc'         => __( 'Enable/Disable Author Information', 'chariton' ),
    ),
    array(
      'id'           => 'single_give_date_switch',
      'type'         => 'switcher',
      'title'        => __( 'Post Date On/Off', 'chariton' ),
      'desc'         => __( 'Enable/Disable date Information', 'chariton' ),
    ),

    array(
      'type'    => 'heading',
      'content' => __( 'Donation Archive Page Settings', 'chariton' ),
    ),
    array(
      'id'      => 'give_archive_column',
      'type'    => 'select',
      'title'   => __( 'Select Archive Page Coulumn', 'chariton' ),
      'options'      => array(
        '4'     => '3 Column ',
        '3'     => '4 Column',
        '6'     => '2 Column',
      ),
      'desc'          => __( 'Select give archive page column.', 'chariton' ),
    ),
    array(
      'id'      => 'give_archive_posts',
      'type'    => 'Text',
      'title'   => __( 'Display Totall Posts', 'chariton' ),
      'default' => '-1',
      'desc'    => __( 'Display totall posts on give archive pages.', 'chariton' ),
    ),
  )
);



/*-----------------------------------------------------------------------------------------*
*   Service Settings
* -----------------------------------------------------------------------------------------*/
$options[]      = array(
  'name'        => 'service_setting',
  'title'       => __( 'Service Settings', 'chariton' ),
  'icon'        => 'fa fa-medkit',
  'fields'      => array(
    
    array(
      'type'    => 'subheading',
      'content' => __( 'Service Single Page Settings', 'chariton' ),
    ),
    array(
      'id'    => 'service_post_slug',
      'type'  => 'text',
      'title' => __( 'Post Slug', 'chariton' ),
      'default' => 'service',
    ),
    array(
      'id'           => 'chariton_service_gutenberg',
      'type'         => 'switcher',
      'title'        => __( 'Gutenberg Enable/Disable Switch', 'chariton' ),
      'default'      => true,
    ),
    array(
      'id'           => 'chariton_service_details_share_enable',
      'type'         => 'switcher',
      'title'        => __( 'Service details share Enable/Disable Switch', 'chariton' ),
      'default'      => true,
    ),
  )
);



/*-----------------------------------------------------------------------------------------*
*   Cause Settings
* -----------------------------------------------------------------------------------------*/
$options[]      = array(
  'name'        => 'cause_setting',
  'title'       => __( 'Cause Settings', 'chariton' ),
  'icon'        => 'fal fa-calendar-star',
  'fields'      => array(
    
    array(
      'type'    => 'subheading',
      'content' => __( 'Cause Single Page Settings', 'chariton' ),
    ),
    array(
      'id'    => 'causes_post_slug',
      'type'  => 'text',
      'title' => __( 'Post Slug', 'chariton' ),
      'default' => 'cause',
    ),
    array(
      'id'           => 'chariton_cause_social_share',
      'type'         => 'switcher',
      'title'        => __( 'Social Share Enable/Disable Switch', 'chariton' ),
      'default'      => false,
    ),
  )
);




/*-----------------------------------------------------------------------------------------*
*   Team Settings
* -----------------------------------------------------------------------------------------*/
$options[]      = array(
  'name'        => 'team_setting',
  'title'       => __( 'Team Settings', 'chariton' ),
  'icon'        => 'fal fa-users',
  'fields'      => array(
    
    array(
      'type'    => 'subheading',
      'content' => __( 'Team Single Page Settings', 'chariton' ),
    ),
    array(
      'id'    => 'team_details_breadcrumb_title',
      'type'  => 'text',
      'title' => __( 'Breadcrumb Title', 'chariton' ),
      'default' => __( 'Team Details', 'chariton' ),
    ),
    array(
      'id'    => 'team_post_slug',
      'type'  => 'text',
      'title' => __( 'Post Slug', 'chariton' ),
      'default' => 'team',
    ),
    array(
      'id'           => 'chariton_team_gutenberg',
      'type'         => 'switcher',
      'title'        => __( 'Gutenberg Enable/Disable Switch', 'chariton' ),
      'default'      => true,
    ),
  )
);


/*-----------------------------------------------------------------------------------------*
*   Testimonial Settings
* -----------------------------------------------------------------------------------------*/
$options[]      = array(
  'name'        => 'testimonial_setting',
  'title'       => __( 'Testimonial Settings', 'chariton' ),
  'icon'        => 'fal fa-quote-left',
  'fields'      => array(
    
    array(
      'type'    => 'subheading',
      'content' => __( 'Testimonial Single Page Settings', 'chariton' ),
    ),
    array(
      'id'           => 'chariton_testimonial_gutenberg',
      'type'         => 'switcher',
      'title'        => __( 'Gutenberg Enable/Disable Switch', 'chariton' ),
      'default'      => true,
    ),

  )
);



/*-----------------------------------------------------------------------------------------*
*   Events Settings
* -----------------------------------------------------------------------------------------*/

$options[]      = array(
  'name'        => 'events_setting',
  'title'       => __( 'Events Settings', 'chariton' ),
  'icon'        => 'fal fa-calendar-check',
  'fields'      => array(
    
    array(
      'type'    => 'subheading',
      'content' => __( 'Events Single Page Settings', 'chariton' ),
    ),
    array(
      'id'           => 'event_details_feature_img_switch',
      'type'         => 'switcher',
      'title'        => __( 'Feature Image Enable/Disable Switch', 'chariton' ),
    ),
    array(
      'id'        => 'event_details_text',
      'type'      => 'text',
      'title'     => __( 'Events Details', 'chariton' ),
      'default'   => 'Event Details',
    ),
    array(
      'id'        => 'organizer_details_text',
      'type'      => 'text',
      'title'     => __( 'Organizer Details', 'chariton' ),
      'default'   => 'Organizer Details',
    ),

  )
);



/*-----------------------------------------------------------------------------------------*
*   Geoport Shop Settings
* -----------------------------------------------------------------------------------------*/

$options[]      = array(
  'name'        => 'shop_setting',
  'title'       => __( 'Shop Page Settings', 'chariton' ),
  'icon'        => 'fa fa-shopping-bag',
  'fields'      => array(

    array(
      'type'    => 'heading',
      'content' => __( 'Shop Page Settings', 'chariton' ),
    ),
    array(
      'id'      => 'shop_page_breadcrumb_title',
      'type'    => 'text',
      'title'   => __( 'Shop Page Breadcrumb Title', 'chariton' ),
      'default' => __( 'Shop', 'chariton' ),
    ),
    array(
      'id'    => 'shop_posts_per_page',
      'type'  => 'text',
      'title' => __( 'Products per page', 'chariton' ),
      'default' => '12',
    ),
    array(
      'id'           => 'shop_layout',
      'type'         => 'image_select',
      'title'        => __( 'Shop Page Layout', 'chariton' ),
      'options'      => array(
        'left-sidebar'  => CHARITON_PLG_URL. 'assets/imgs/sidebar_l.jpg',
        'right-sidebar' => CHARITON_PLG_URL. 'assets/imgs/sidebar_r.jpg',
        'full-width'    => CHARITON_PLG_URL. 'assets/imgs/fullwidth.jpg',
        ),
      'desc'       => __( 'Choose page layout style.', 'chariton' ),
    ),
    array(
      'id'           => 'product_col_layout',
      'type'         => 'image_select',
      'title'        => __( 'Product column layout', 'chariton' ),
      'options'      => array(
        '2' => CHARITON_PLG_URL. 'assets/imgs/columns-2.png',
        '3' => CHARITON_PLG_URL. 'assets/imgs/columns-3.png',
        '4' => CHARITON_PLG_URL. 'assets/imgs/columns-4.png',
        ),
    ),

    array(
      'type'    => 'subheading',
      'content' => __( 'Shop Single Page Settings', 'chariton' ),
    ),
    array(
      'id'      => 'shop_single_breadcrumb_title',
      'type'    => 'text',
      'title'   => __( 'Shop Single Page Breadcrumb Title', 'chariton' ),
      'default' => __( 'Shop', 'chariton' ),
    ),
    array(
      'id'           => 'related_products',
      'type'         => 'switcher',
      'title'        => __( 'Enable/Disable Related Product', 'chariton' ),
      'default'      => true,
      'desc'    => __( 'Enable/Disable related product on product details page.', 'chariton' ),
    ),
    array(
      'id'           => 'related_product_col_layout',
      'type'         => 'image_select',
      'title'        => __( 'Related product column layout', 'chariton' ),
      'options'      => array(
        '2' => CHARITON_PLG_URL. 'assets/imgs/columns-2.png',
        '3' => CHARITON_PLG_URL. 'assets/imgs/columns-3.png',
        '4' => CHARITON_PLG_URL. 'assets/imgs/columns-4.png',
      ),
    ),
    array(
      'id'           => 'related_products_per_page',
      'type'         => 'text',
      'title'        => __( 'Related product per page', 'chariton' ),
      'default'      => 3,
      'desc'    => __( 'How much related product display in single page', 'chariton' ),
    ),

    array(
      'type'    => 'subheading',
      'content' => __( 'Shop Global Color Settings', 'chariton' ),
    ),
    array(
      'id'      => 'shop_base_color',
      'type'    => 'color_picker',
      'title'   => __( 'Shop base color', 'chariton' ),
      'desc'    => __( 'Change your all shop base color.', 'chariton' ),
      'default' => '#39bdb2',
    ),

    array(
      'type'    => 'subheading',
      'content' => __( 'Shop Button Color Settings', 'chariton' ),
    ),
    array(
      'id'      => 'shop_btnbg_color',
      'type'    => 'color_picker',
      'title'   => __( 'Button Background color', 'chariton' ),
      'desc'    => __( 'Change shop button background color.', 'chariton' ),
      'default' => '#39bdb2',
    ),
    array(
      'id'      => 'shop_btn_text_color',
      'type'    => 'color_picker',
      'title'   => __( 'Button Text color', 'chariton' ),
      'desc'    => __( 'Change shop button text color.', 'chariton' ),
      'default' => '#ffffff',
    ),

    array(
      'id'      => 'shop_btnbg_hover_color',
      'type'    => 'color_picker',
      'title'   => __( 'Button Hover Background color', 'chariton' ),
      'desc'    => __( 'Change shop button hover background color.', 'chariton' ),
      'default' => '#000d38',
    ),
    array(
      'id'      => 'shop_btnbg_hover_text_color',
      'type'    => 'color_picker',
      'title'   => __( 'Button Hover Text color', 'chariton' ),
      'desc'    => __( 'Change shop button hover text color.', 'chariton' ),
      'default' => '#ffffff',
    ),

    array(
      'type'    => 'subheading',
      'content' => __( 'Shop Pagination Color Settings', 'chariton' ),
    ),
    array(
      'id'      => 'shop_pagination_color',
      'type'    => 'color_picker',
      'title'   => __( 'Pagination Background color', 'chariton' ),
      'desc'    => __( 'Change shop pagination background color.', 'chariton' ),
      'default' => '#ffffff',
    ),
    array(
      'id'      => 'shop_pagination_text_color',
      'type'    => 'color_picker',
      'title'   => __( 'Pagination Text color', 'chariton' ),
      'desc'    => __( 'Change shop pagination text color.', 'chariton' ),
      'default' => '#001d67',
    ),

    array(
      'id'      => 'shop_pagination_hover_color',
      'type'    => 'color_picker',
      'title'   => __( 'Pagination Hover Background color', 'chariton' ),
      'desc'    => __( 'Change shop pagination hover background color.', 'chariton' ),
      'default' => '#39bdb2',
    ),
    array(
      'id'      => 'shop_pagination_hover_text_color',
      'type'    => 'color_picker',
      'title'   => __( 'Pagination Hover Text color', 'chariton' ),
      'desc'    => __( 'Change shop pagination hover text color.', 'chariton' ),
      'default' => '#ffffff',
    ),  

    array(
      'id'      => 'shop_pagination_active_color',
      'type'    => 'color_picker',
      'title'   => __( 'Pagination Active Background color', 'chariton' ),
      'desc'    => __( 'Change shop pagination active background color.', 'chariton' ),
      'default' => '#39bdb2',
    ),
    array(
      'id'      => 'shop_pagination_active_text_color',
      'type'    => 'color_picker',
      'title'   => __( 'Pagination Active Text color', 'chariton' ),
      'desc'    => __( 'Change shop pagination active text color.', 'chariton' ),
      'default' => '#ffffff',
    ),    
  
  )
);



// ===================================================================
// Search Page Settings =
// ===================================================================

$options[]      = array(
  'name'        => 'search_page',
  'title'       => __( 'Search Page Settings', 'chariton' ),
  'icon'        => 'fa fa-search-plus',
  // begin: fields
  'fields'      => array(
    array(
      'type'    => 'heading',
      'content' => __( 'No Search Reasult Page', 'chariton' ),
    ),
    array(
      'id'      => 'search_none_page_title',
      'type'    => 'text',
      'title'   => __( 'Search none page title', 'chariton' ),
      'default' => 'Nothing Found'
    ),
    array(
      'id'      => 'search_none_page_desc',
      'type'    => 'textarea',
      'title'   => __( 'Page Sub Title', 'chariton' ),
      'default' => 'Sorry, but nothing matched your search terms. Please try again with some different keywords.'
    ),
  
  )
);




// ===================================================================
// 404 Page Settings = 
// ===================================================================

$options[]      = array(
  'name'        => '404_page',
  'title'       =>  __( '404 Page Settings', 'chariton' ),
  'icon'        => 'fal fa-exclamation-triangle',
  // begin: fields
  'fields'      => array(

    array(
      'id'      => '404_breadcrumb_title',
      'type'    => 'text',
      'title'   =>  __( 'Breadcrumb Title', 'chariton' ),
      'default' => __( 'ERROR 404', 'chariton' ),
      'desc'    => __( '404 page breadcrumb title.', 'chariton' ),
    ),
    array(
      'id'      => '404_text',
      'type'    => 'text',
      'title'   =>  __( '404 text', 'chariton' ),
      'default' => __( '404', 'chariton' ),
      'desc'    => __( '404 page text.', 'chariton' ),
    ),
    array(
      'id'      => '404_page_title',
      'type'    => 'text',
      'title'   =>  __( '404 Page Title', 'chariton' ),
      'default' => __( 'Sorry Page Not Found', 'chariton' ),
      'desc'    => __( '404 page title.', 'chariton' ),
    ),
    array(
      'id'      => '404_page_desc',
      'type'    => 'textarea',
      'title'   =>  __( '404 Page Description', 'chariton' ),
      'default' => __( 'The page you are looking for was removed or might never existed.', 'chariton' ),
      'desc'    => __( '404 page description.', 'chariton' ),
    ),
    array(
      'id'      => '404_btn_txt',
      'type'    => 'text',
      'title'   =>  __( 'Button Text', 'chariton' ),
      'default' => __( 'Back to Home', 'chariton' ),
      'desc'    => __( '404 page button text.', 'chariton' ),
    ), 
  
  )
);


// ===================================================================
// Footer Options =
// ===================================================================

$options[]      = array(
  'name'        => 'footer_setting',
  'title'       =>  __( 'Footer Settings', 'chariton' ),
  'icon'        => 'fab fa-foursquare',
  'sections' => array(

    array(
      'name'     => 'main_footer_001',
      'title'    => 'Copyright Information',
      'icon'     => 'fal fa-plus',
      'fields'      => array(
        array(
          'type'    => 'subheading',
          'content' => __( 'Copyright Information', 'chariton' ),
        ),
        array(
          'id'        => 'copyrights',
          'type'      => 'textarea',
          'title'     =>  __( 'Copyright Information', 'chariton' ),
          'default'   => 'Copyright &copy; 2024, Chariton. Theme Developed by <a href="https://ifingerstudio.com" title="ifingerstudio">Ifingerstudio.com</a>',
          'sanitize'  => false,
          'desc'    => __( 'Insert Copyright Information.', 'chariton' ),
        ),
        array(
          'id'      => 'footer_two_copy_background_color',
          'type'    => 'color_picker',
          'title'   => __( 'Copyright Background Color', 'chariton' ),
          'desc'    => __( 'Pick Copyright Area Background Color.', 'chariton' ),
          'default' => '#000000',
        ),
        array(
          'id'      => 'footer_copyright_text_color',
          'type'    => 'color_picker',
          'title'   => __( 'Copyright Text Color', 'chariton' ),
          'desc'    => __( 'Pick Copyright Text Color.', 'chariton' ),
          'default' => '#808eaa',
        ),
        array(
          'id'      => 'footer_copyright_link_color',
          'type'    => 'color_picker',
          'title'   => __( 'Copyright Link Color', 'chariton' ),
          'desc'    => __( 'Pick Copyright Link Color.', 'chariton' ),
          'default' => '#39bdb2',
        ),
        array(
          'id'      => 'footer_copyright_link_hover_color',
          'type'    => 'color_picker',
          'title'   => __( 'Copyright Link Hover Color', 'chariton' ),
          'desc'    => __( 'Pick Copyright Link Hover Color.', 'chariton' ),
          'default' => '#ff566e',
        ),
      ),
    ),

    array(
      'name'     => 'main_footer_toppart',
      'title'    => 'Footer Top Settings',
      'icon'     => 'fal fa-plus',
      'fields'      => array(
        array(
          'type'    => 'heading',
          'content' => __( 'Footer Top Part Settings', 'chariton' ),
        ),
        array(
          'id'      => 'default_ftp',
          'type'    => 'switcher',
          'default' => true,
          'title'   =>  __( 'Top Part', 'chariton' ),
          'desc'    => __( 'On/Off Footer Top Part.', 'chariton' ),
        ),
        array(
          'id'      => 'footer_logo',
          'type'    => 'image',
          'title'   =>  __( 'Top Part Logo', 'chariton' ),
          'default'     => CHARITON_PLG_URL. 'assets/imgs/logo3.png',
          'desc'    => __( 'Upload footer top part logo.', 'chariton' ),
        ),
        array(
          'id'              => 'footer_contact_list',
          'type'            => 'group',
          'title'           =>  __( 'Top Part Contact Info', 'chariton' ),
          'button_title'    =>  __( 'Add New', 'chariton' ),
          'accordion_title' =>  __( 'Add New Field', 'chariton' ),
          'desc'            => __( 'Top Part Contact Information.', 'chariton' ),
          'fields'          => array(
            array(
              'id'          => 'icon',
              'type'        => 'icon',
              'title'       =>  __( 'Icon' ),
            ),
            array(
              'id'          => 'title',
              'type'        => 'text',
              'title'       =>  __( 'Title' ),
            ),
            array(
              'id'          => 'desc',
              'type'        => 'text',
              'title'       =>  __( 'Description' ),
            ),
          ),
          'default'   => array(
            array(
              'icon'         => 'far fa-phone',
              'title'        => 'Call Us Now',
              'desc'         => '+987 876 875 76 56 6',
            ),
            array(
              'icon'         => 'far fa-envelope',
              'title'        => 'Send An Email',
              'desc'         => 'info@yourdomain.com',
            ),
            array(
              'icon'         => 'fab fa-facebook-f',
              'title'        => 'Connect With Us',
              'desc'         => 'https://www.facebook.com',
            ),
          ),
        ),
        array(
          'id'      => 'footer_top_icon_color1',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Contact Icon 1 Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '#ff566e',
        ),
        array(
          'id'      => 'footer_top_icon_color2',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Contact Icon 2 Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '#00ffde',
        ),
        array(
          'id'      => 'footer_top_icon_color3',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Contact Icon 3 Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '#52c76b',
        ),
        array(
          'id'      => 'footer_top_border_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Border Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '#1a2437',
        ),
        array(
          'id'      => 'footer_top_title_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Title Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '#ffffff',
        ),
        array(
          'id'      => 'footer_top_link_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Link Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '#a7b6d3',
        ),
        array(
          'id'      => 'footer_top_linkhover_color',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Link Hover Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '#ff4c7c',
        ),
      ),
    ),

    // Footer Style Settings
    array(
      'name'     => 'main_footer_002',
      'title'    => 'Footer Style Settings',
      'icon'     => 'fal fa-plus',
      'fields'      => array(
        array(
          'type'    => 'heading',
          'content' => __( 'Select Footer Style', 'chariton' ),
        ),
        array(
          'id'          => 'select_footer_style',
          'type'        => 'image_select',
          'title'       => __( 'Select Default Footer Style', 'chariton' ),
          'options'     => array(
            'style1'    => CHARITON_PLG_URL. 'assets/imgs/footer1.jpg',
            'style2'    => CHARITON_PLG_URL. 'assets/imgs/footer2.jpg',
          ),
          'desc'   => __( 'This is all default page footer style if you select','chariton'),
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Footer Background Color Settings', 'chariton' ),
        ),

        array(
          'id'      => 'footer_background_color',
          'type'    => 'color_picker',
          'title'   => __( 'Background Color', 'chariton' ),
          'desc'    => __( 'Pick Footer Area Background Color.', 'chariton' ),
          'default' => '#000b20',
        ),

        array(
          'id'      => 'select_footer_columns',
          'type'    => 'select',
          'title'   => 'Select Footer Widgets Columns',
          'options' => array(
            '6'   => '2',
            '4'   => '3',
            '3'   => '4',
            '2'   => '6',
          ),
          'default_option' => '4',
          'desc'    => __( 'Select Footer Widgets Column.', 'chariton' ),
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Footer Two Widgets Column Settings', 'chariton' ),
        ),

        array(
          'id'             => 'footer2_widget1_columns',
          'type'           => 'select',
          'title'          => 'Select Footer 1 Columns',
          'options'        => array(
            '2'   => '2',
            '3'   => '3',
            '4'   => '4',
            '5'   => '5',
            '6'   => '6',
            '7'   => '7',
            '8'   => '8',
          ),
          'default_option' => '4',
          'desc'          => __( 'Total footer area columns is 12', 'chariton' )
        ),

        array(
          'id'             => 'footer2_widget2_columns',
          'type'           => 'select',
          'title'          => 'Select Footer 2 Columns',
          'options'        => array(
            '2'   => '2',
            '3'   => '3',
            '4'   => '4',
            '5'   => '5',
            '6'   => '6',
            '7'   => '7',
            '8'   => '8',
          ),
          'default_option' => '2',
          'desc'          => __( 'Total footer area columns is 12', 'chariton' )
        ),

        array(
          'id'             => 'footer2_widget3_columns',
          'type'           => 'select',
          'title'          => 'Select Footer 3 Columns',
          'options'        => array(
            '2'   => '2',
            '3'   => '3',
            '4'   => '4',
            '5'   => '5',
            '6'   => '6',
            '7'   => '7',
            '8'   => '8',
          ),
          'default_option' => '3',
          'desc'          => __( 'Total footer area columns is 12', 'chariton' )
        ),

        array(
          'id'             => 'footer2_widget4_columns',
          'type'           => 'select',
          'title'          => 'Select Footer 4 Columns',
          'options'        => array(
            '2'   => '2',
            '3'   => '3',
            '4'   => '4',
            '5'   => '5',
            '6'   => '6',
            '7'   => '7',
            '8'   => '8',
          ),
          'default_option' => '3',
          'desc'          => __( 'Total footer area columns is 12', 'chariton' )
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Footer Widgets Color Settings', 'chariton' ),
        ),

        array(
          'id'      => 'footer_wid_title_color',
          'type'    => 'color_picker',
          'title'   => __( 'Widgets Title Color', 'chariton' ),
          'desc'    => __( 'Pick Footer Widgets Title Color.', 'chariton' ),
          'default' => '#ffffff',
        ),

        array(
          'id'      => 'footer_wid_content_color',
          'type'    => 'color_picker',
          'title'   => __( ' Widgets Content Color', 'chariton' ),
          'desc'    => __( 'Pick Footer Widgets Content Color.', 'chariton' ),
          'default' => '#a7b6d3',
        ),

        array(
          'id'      => 'footer_widgets_link_color',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Link Color', 'chariton' ),
          'desc'    => __( 'Pick Widgets Link Color.', 'chariton' ),
          'default' => '#a7b6d3',
        ),

        array(
          'id'      => 'footer_widgets_linkh_color',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Link Hover Color', 'chariton' ),
          'desc'    => __( 'Pick Widgets Link Hover Color.', 'chariton' ),
          'default' => '#39bdb2',
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Footer Social Widgets Color Settings', 'chariton' ),
        ),

        array(
          'id'      => 'footer_widgets_socialbg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Social Background Color', 'chariton' ),
          'desc'    => __( 'Choose footer widgets social background color.', 'chariton' ),
          'default' => '#fff',
        ),

        array(
          'id'      => 'footer_widgets_social_link_color',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Social Link Color', 'chariton' ),
          'desc'    => __( 'Choose footer widgets social link color.', 'chariton' ),
          'default' => '#fe3233',
        ),

        array(
          'id'      => 'footer_widgets_social_linkh_color',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Social Link Hover Color', 'chariton' ),
          'desc'    => __( 'Choose footer widgets social Link Hover color.', 'chariton' ),
          'default' => '#fe3233',
        ),

      ),
    ),
  ),
  // end: fields
);


// ------------------------------
// a seperator                  -
// ------------------------------
$options[] = array(
  'name'   => 'seperator_1',
  'title'  =>  __( 'A Seperator', 'chariton' ),
  'icon'   => 'fa fa-bookmark'
);


// ------------------------------
// backup                       -
// ------------------------------
$options[]   = array(
  'name'     => 'backup_section',
  'title'    =>  __( 'Backup', 'chariton' ),
  'icon'     => 'fa fa-shield',
  'fields'   => array(

    array(
      'type'    => 'notice',
      'class'   => 'warning',
      'content' =>  __( 'You can save your current options. Download a Backup and Import.', 'chariton' ),
    ),

    array(
      'type'    => 'backup',
    ),

  )
);


charitonFramework::instance( $settings, $options );
