<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.

/*------------------------------------------------------------------------------------------------------------------*/
/*  Services Custom Post
/*------------------------------------------------------------------------------------------------------------------*/

function service_init() {
    $service_gutenberg = chariton_get_option('chariton_service_gutenberg');
    if ( $service_gutenberg == 1 ) {
        $guten = true;
    } else {
       $guten = false; 
    }
    $labels = array(
        'name'               => _x( 'Services', 'post type general name', 'chariton' ),
        'singular_name'      => _x( 'Service', 'post type singular name', 'chariton' ),
        'menu_name'          => __( 'Services', 'chariton' ),
        'name_admin_bar'     => __( 'Service', 'chariton' ),
        'add_new'            => __( 'Add New', 'chariton' ),
        'add_new_item'       => __( 'Add New Service', 'chariton' ),
        'new_item'           => __( 'New Service', 'chariton' ),
        'edit_item'          => __( 'Edit Service', 'chariton' ),
        'view_item'          => __( 'View Service', 'chariton' ),
        'all_items'          => __( 'All Services', 'chariton' ),
        'search_items'       => __( 'Search Services', 'chariton' ),
        'parent_item_colon'  => __( 'Parent Services:', 'chariton' ),
        'not_found'          => __( 'No Service found.', 'chariton' ),
        'not_found_in_trash' => __( 'No Service found in Trash.', 'chariton' )
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => true,
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => true,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-hammer',
        'show_in_rest'       => $guten,
        'supports'           => array( 'title', 'editor', 'thumbnail' )
    );

  register_post_type('service', $args);
}
add_action('init', 'service_init');

/* Service Texonomy
=====================================================*/

function create_service_taxonomies() {
  $labels = array(
    'name'                  => _x( 'Service Category', 'Taxonomy plural name', 'chariton' ),
    'singular_name'         => _x( 'Service Category', 'Taxonomy singular name', 'chariton' ),
    'search_items'          => __( 'Search Service Category', 'chariton' ),
    'popular_items'         => __( 'Popular Service Category', 'chariton' ),
    'all_items'             => __( 'All Categories', 'chariton' ),
    'parent_item'           => __( 'Parent Service Category', 'chariton' ),
    'parent_item_colon'     => __( 'Parent Service Category', 'chariton' ),
    'edit_item'             => __( 'Edit Service Category', 'chariton' ),
    'update_item'           => __( 'Update Service Category', 'chariton' ),
    'add_new_item'          => __( 'Add New Category', 'chariton' ),
    'new_item_name'         => __( 'New Service Menu Name', 'chariton' ),
    'add_or_remove_items'   => __( 'Add or remove Service Category', 'chariton' ),
    'choose_from_most_used' => __( 'Choose from most used text-domain', 'chariton' ),
    'menu_name'             => __( 'Categories', 'chariton' ),
  );

  $args = array(
    'labels'            => $labels,
    'public'            => true,
    'show_in_nav_menus' => true,
    'show_admin_column' => true,
    'hierarchical'      => true,
    'show_tagcloud'     => true,
    'show_ui'           => true,
    'query_var'         => true,
    'rewrite'           => true,
    'query_var'         => true,
    'capabilities'      => array(),
  );

  register_taxonomy( 'service_category', array( 'service' ), $args );
}
add_action( 'init', 'create_service_taxonomies' );

function update_service_post_slug( $args, $post_type ) {
    $service_post_slug = chariton_get_option('service_post_slug');
    if ( 'service' === $post_type ) {
        $my_args = array(
            'rewrite' => array( 'slug' => $service_post_slug, 'with_front' => false )
        );
        return array_merge( $args, $my_args );
    }
    return $args;
}
add_filter( 'register_post_type_args', 'update_service_post_slug', 10, 2 );


/*------------------------------------------------------------------------------------------------------------------*/
/*  Causes Custom Post
/*------------------------------------------------------------------------------------------------------------------*/

function causes_init() {    
    $labels = array(
        'name'               => _x( 'Causes', 'post type general name', 'chariton' ),
        'singular_name'      => _x( 'Cause', 'post type singular name', 'chariton' ),
        'menu_name'          => __( 'Causes', 'chariton' ),
        'name_admin_bar'     => __( 'Cause', 'chariton' ),
        'add_new'            => __( 'Add New', 'chariton' ),
        'add_new_item'       => __( 'Add New Cause', 'chariton' ),
        'new_item'           => __( 'New Cause', 'chariton' ),
        'edit_item'          => __( 'Edit Cause', 'chariton' ),
        'view_item'          => __( 'View Cause', 'chariton' ),
        'all_items'          => __( 'All Causes', 'chariton' ),
        'search_items'       => __( 'Search Causes', 'chariton' ),
        'parent_item_colon'  => __( 'Parent Causes:', 'chariton' ),
        'not_found'          => __( 'No Cause found.', 'chariton' ),
        'not_found_in_trash' => __( 'No Cause found in Trash.', 'chariton' )
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => true,
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => true,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-share-alt',
        'supports'           => array( 'title', 'editor', 'thumbnail', 'comments' ),
    );

  register_post_type('cause', $args);
}
add_action('init', 'causes_init');

/* Cause Texonomy
=====================================================*/

function create_cause_taxonomies() {
  $labels = array(
    'name'                  => _x( 'Cause Category', 'Taxonomy plural name', 'chariton' ),
    'singular_name'         => _x( 'Cause Category', 'Taxonomy singular name', 'chariton' ),
    'search_items'          => __( 'Search Cause Category', 'chariton' ),
    'popular_items'         => __( 'Popular Cause Category', 'chariton' ),
    'all_items'             => __( 'All Categories', 'chariton' ),
    'parent_item'           => __( 'Parent Cause Category', 'chariton' ),
    'parent_item_colon'     => __( 'Parent Cause Category', 'chariton' ),
    'edit_item'             => __( 'Edit Cause Category', 'chariton' ),
    'update_item'           => __( 'Update Cause Category', 'chariton' ),
    'add_new_item'          => __( 'Add New Category', 'chariton' ),
    'new_item_name'         => __( 'New Cause Menu Name', 'chariton' ),
    'add_or_remove_items'   => __( 'Add or remove Cause Category', 'chariton' ),
    'choose_from_most_used' => __( 'Choose from most used text-domain', 'chariton' ),
    'menu_name'             => __( 'Categories', 'chariton' ),
  );

  $args = array(
    'labels'            => $labels,
    'public'            => true,
    'show_in_nav_menus' => true,
    'show_admin_column' => true,
    'hierarchical'      => true,
    'show_tagcloud'     => true,
    'show_ui'           => true,
    'query_var'         => true,
    'rewrite'           => true,
    'query_var'         => true,
    'capability_type'   => 'page',
  );

  register_taxonomy( 'cause_category', array( 'cause' ), $args );
}
add_action( 'init', 'create_cause_taxonomies' );


function update_causes_post_slug( $args, $post_type ) {
    $cause_post_slug = chariton_get_option('causes_post_slug');
    if ( 'cause' === $post_type ) {
        $my_args = array(
            'rewrite' => array( 'slug' => $cause_post_slug, 'with_front' => false )
        );
        return array_merge( $args, $my_args );
    }
    return $args;
}
add_filter( 'register_post_type_args', 'update_causes_post_slug', 10, 2 );


/*------------------------------------------------------------------------------------------------------------------*/
/*  Team Custom Post
/*------------------------------------------------------------------------------------------------------------------*/
function team_init() {
    $team_gutenberg = chariton_get_option('chariton_team_gutenberg');
    if ( $team_gutenberg == 1 ) {
        $teamguten = true;
    } else {
       $teamguten = false; 
    }

    $labels = array(
        'name'               => _x( 'Team', 'post type general name', 'chariton' ),
        'singular_name'      => _x( 'Team', 'post type singular name', 'chariton' ),
        'menu_name'          => __( 'Team', 'chariton' ),
        'name_admin_bar'     => __( 'Team', 'chariton' ),
        'add_new'            => __( 'Add New', 'chariton' ),
        'add_new_item'       => __( 'Add New Team', 'chariton' ),
        'new_item'           => __( 'New Team', 'chariton' ),
        'edit_item'          => __( 'Edit Team', 'chariton' ),
        'view_item'          => __( 'View Team', 'chariton' ),
        'all_items'          => __( 'All Teams', 'chariton' ),
        'search_items'       => __( 'Search Team', 'chariton' ),
        'parent_item_colon'  => __( 'Parent Team:', 'chariton' ),
        'not_found'          => __( 'No Team found.', 'chariton' ),
        'not_found_in_trash' => __( 'No Team found in Trash.', 'chariton' )
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => true,
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => true,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-buddicons-buddypress-logo',
        'supports'           => array( 'title', 'editor', 'thumbnail' ),
        'show_in_rest'       => $teamguten,
    );

  register_post_type('team', $args);
}
add_action('init', 'team_init');


/* Team Texonomy
=====================================================*/

function create_team_taxonomies() {
  $labels = array(
    'name'                  => _x( 'Team Category', 'Taxonomy plural name', 'chariton' ),
    'singular_name'         => _x( 'Team Category', 'Taxonomy singular name', 'chariton' ),
    'search_items'          => __( 'Search Team Category', 'chariton' ),
    'popular_items'         => __( 'Popular Team Category', 'chariton' ),
    'all_items'             => __( 'All Categories', 'chariton' ),
    'parent_item'           => __( 'Parent Team Category', 'chariton' ),
    'parent_item_colon'     => __( 'Parent Team Category', 'chariton' ),
    'edit_item'             => __( 'Edit Team Category', 'chariton' ),
    'update_item'           => __( 'Update Team Category', 'chariton' ),
    'add_new_item'          => __( 'Add New Category', 'chariton' ),
    'new_item_name'         => __( 'New Team Menu Name', 'chariton' ),
    'add_or_remove_items'   => __( 'Add or remove Team Categories', 'chariton' ),
    'choose_from_most_used' => __( 'Choose from most used text-domain', 'chariton' ),
    'menu_name'             => __( 'Categories', 'chariton' ),
  );

  $args = array(
    'labels'            => $labels,
    'public'            => true,
    'show_in_nav_menus' => true,
    'show_admin_column' => true,
    'hierarchical'      => true,
    'show_tagcloud'     => true,
    'show_ui'           => true,
    'query_var'         => true,
    'rewrite'           => true,
    'query_var'         => true,
    'capabilities'      => array(),
  );

  register_taxonomy( 'team_category', array( 'team' ), $args );
}
add_action( 'init', 'create_team_taxonomies' );


function update_team_post_slug( $args, $post_type ) {
    $team_post_slug = chariton_get_option('team_post_slug');
    if ( 'team' === $post_type ) {
        $my_args = array(
            'rewrite' => array( 'slug' => $team_post_slug, 'with_front' => false )
        );
        return array_merge( $args, $my_args );
    }
    return $args;
}
add_filter( 'register_post_type_args', 'update_team_post_slug', 10, 2 );

/*------------------------------------------------------------------------------------------------------------------*/
/*  Testimonial Custom Post
/*------------------------------------------------------------------------------------------------------------------*/
function testimonial_init() {
    $testi_gutenberg = chariton_get_option('chariton_testimonial_gutenberg');
    if ( $testi_gutenberg == 1 ) {
        $testiguten = true;
    } else {
       $testiguten = false; 
    }

    $labels = array(
        'name'               => _x( 'Testimonial', 'post type general name', 'chariton' ),
        'singular_name'      => _x( 'Testimonial', 'post type singular name', 'chariton' ),
        'menu_name'          => __( 'Testimonial', 'chariton' ),
        'name_admin_bar'     => __( 'Testimonial', 'chariton' ),
        'add_new'            => __( 'Add New', 'chariton' ),
        'add_new_item'       => __( 'Add New Testimonial', 'chariton' ),
        'new_item'           => __( 'New Testimonial', 'chariton' ),
        'edit_item'          => __( 'Edit Testimonial', 'chariton' ),
        'view_item'          => __( 'View Testimonial', 'chariton' ),
        'all_items'          => __( 'All Testimonials', 'chariton' ),
        'search_items'       => __( 'Search Testimonial', 'chariton' ),
        'parent_item_colon'  => __( 'Parent Testimonial:', 'chariton' ),
        'not_found'          => __( 'No Testimonial found.', 'chariton' ),
        'not_found_in_trash' => __( 'No Testimonial found in Trash.', 'chariton' )
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => true,
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => true,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-editor-quote',
        'supports'           => array( 'title', 'editor' ),
        'show_in_rest'       => $testiguten,
    );

  register_post_type('testimonial', $args);
}
add_action('init', 'testimonial_init');


/*------------------------------------------------------------------------------------------------------------------*/
/*  Portfolio Custom Post
/*------------------------------------------------------------------------------------------------------------------*/

function chariton_portfolios_init() {
    $labels = array(
        'name'               => _x( 'Portfolio', 'post type general name', 'chariton' ),
        'singular_name'      => _x( 'Portfolio', 'post type singular name', 'chariton' ),
        'menu_name'          => __( 'Portfolios', 'chariton' ),
        'name_admin_bar'     => __( 'Portfolio', 'chariton' ),
        'add_new'            => __( 'Add New', 'chariton' ),
        'add_new_item'       => __( 'Add New Portfolio', 'chariton' ),
        'new_item'           => __( 'New Portfolio', 'chariton' ),
        'edit_item'          => __( 'Edit Portfolio', 'chariton' ),
        'view_item'          => __( 'View Portfolio', 'chariton' ),
        'all_items'          => __( 'All Portfolios', 'chariton' ),
        'search_items'       => __( 'Search Portfolios', 'chariton' ),
        'parent_item_colon'  => __( 'Parent Portfolios:', 'chariton' ),
        'not_found'          => __( 'No Portfolio found.', 'chariton' ),
        'not_found_in_trash' => __( 'No Portfolio found in Trash.', 'chariton' )
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => true,
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => true,
        'menu_position'      => null,
        'supports'           => array( 'title', 'editor', 'thumbnail' ),
    );

  register_post_type('portfolio', $args);
}
add_action('init', 'chariton_portfolios_init');


/* Portfolio Texonomy
=====================================================*/

function create_chariton_portfolio_taxonomies() {
  $labels = array(
    'name'                  => _x( 'Portfolio Category', 'Taxonomy plural name', 'chariton' ),
    'singular_name'         => _x( 'Portfolio Category', 'Taxonomy singular name', 'chariton' ),
    'search_items'          => __( 'Search Portfolio Category', 'chariton' ),
    'popular_items'         => __( 'Popular Portfolio Category', 'chariton' ),
    'all_items'             => __( 'All Categories', 'chariton' ),
    'parent_item'           => __( 'Parent Portfolio Category', 'chariton' ),
    'parent_item_colon'     => __( 'Parent Portfolio Category', 'chariton' ),
    'edit_item'             => __( 'Edit Portfolio Category', 'chariton' ),
    'update_item'           => __( 'Update Portfolio Category', 'chariton' ),
    'add_new_item'          => __( 'Add New Category', 'chariton' ),
    'new_item_name'         => __( 'New Portfolio Menu Name', 'chariton' ),
    'add_or_remove_items'   => __( 'Add or remove Portfolio Categories', 'chariton' ),
    'choose_from_most_used' => __( 'Choose from most used text-domain', 'chariton' ),
    'menu_name'             => __( 'Categories', 'chariton' ),
  );

  $args = array(
    'labels'            => $labels,
    'public'            => true,
    'show_in_nav_menus' => true,
    'show_admin_column' => true,
    'hierarchical'      => true,
    'show_tagcloud'     => true,
    'show_ui'           => true,
    'query_var'         => true,
    'rewrite'           => true,
    'query_var'         => true,
    'capability_type'   => 'page',
  );

  register_taxonomy( 'portfolio_category', array( 'portfolio' ), $args );
}
add_action( 'init', 'create_chariton_portfolio_taxonomies' );