<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.

/*------------------------------------------------------------------------------------------------------------------*/
/*  Custom page sidebar register
/*------------------------------------------------------------------------------------------------------------------*/
/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 *
 *
**/

/*============================================================================================================================*/
/* - About Widget
/*============================================================================================================================*/ 
if( ! class_exists( 'chariton_about_me_Widget' ) ) {

    //Footer About Widget
    class chariton_about_me_Widget extends WP_Widget {

        /*=====================================================
        // = Widget Register
        /*=====================================================*/
        function __construct() {

          $widget_ops     = array(
            'classname'   => 'chariton_about_me_widget',
            'description' => __( 'Chariton About Me Widget.', 'chariton' )
          );

          parent::__construct( 'address_widget', __( 'A::1 About Me Widget', 'chariton' ), $widget_ops );

        }

        /*=====================================================
        // = Front-end Setting
        /*=====================================================*/
        function widget( $args, $instance ) {

          extract( $args );
          echo $before_widget; ?>

            <?php 

              if (!empty($instance['title'])) {
                $title = $instance['title'];
              } else {
                $title = '';
              } 

              if (!empty($instance['about_me_desc'])) {
                $about_me_desc = $instance['about_me_desc'];
              } else {
                $about_me_desc = '';
              } 

              if (!empty($instance['about_name'])) {
                $about_name = $instance['about_name'];
              } else {
                $about_name = '';
              } 

              if (!empty($instance['social_list'])) {
                $social_list = $instance['social_list'];
              } else {
                $social_list = '';
              }

              if ( !empty($instance['about_me_widget_logo'])) {
                $image_id = $instance['about_me_widget_logo'];
                $attachment = wp_get_attachment_image_src( $image_id, 'full' );
                $image =($attachment) ? $attachment[0] : $image_id;
              } else {
                $image = '';
              }

            ?> 

            <div class="widget-title mb-35">
              <span></span>
              <h4><?php echo $title; ?></h4>
            </div>
            <div class="blog-about text-center">
              <div class="blog-avatar-img mb-25">
                <img src="<?php echo esc_url( $image ); ?>" alt="<?php esc_attr_e( 'Author logo', 'chariton' ); ?>">
              </div>
              <div class="b-about-content mb-20">
                <h4><?php echo $about_name; ?></h4>
                <p><?php echo $about_me_desc; ?></p>
              </div>
              <?php if (!empty( $social_list)) { ?>
                <div class="b-about-social">
                  <?php echo $social_list; ?>
                </div>
              <?php } ?>
            </div>

          <?php echo $after_widget;
        }
        /*=====================================================
        // = Widget Update Setting
        /*=====================================================*/
        function update( $new_instance, $old_instance ) {

          $instance                         = $old_instance;
          $instance['title']                = $new_instance['title'];
          $instance['about_me_widget_logo'] = $new_instance['about_me_widget_logo'];
          $instance['about_name']           = $new_instance['about_name'];
          $instance['about_me_desc']        = $new_instance['about_me_desc'];
          $instance['social_list']          = $new_instance['social_list'];

          return $instance;

        }

        /*=====================================================
        // = Widget Form Setting
        /*=====================================================*/
        function form( $instance ) {

          /* -------------------------------------------------
          /* - Defaults Value Seiitng Fields
          /*------------------------------------------------- */
          $instance   = wp_parse_args( $instance, array(
            'title'                => 'About Me',
            'about_me_widget_logo' => CHARITON_PLG_URL. 'assets/imgs/me.png',
            'about_name'           => 'Rosalina D. Willaimson',
            'about_me_desc'        => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.',
            'social_list' => '
              <a href="#" class="facebook"><i class="fab fa-facebook-f"></i></a>
              <a href="#" class="twitter"><i class="fab fa-twitter"></i></a>
              <a href="#" class="instagram"><i class="fab fa-pinterest"></i></a>
              <a href="#" class="pinterest"><i class="fab fa-behance"></i></a>
              <a href="#" class="pinterest"><i class="fab fa-youtube"></i></a>',
          ));


          /* -------------------------------------------------
          /* - Widget Title Seiitng
          /*------------------------------------------------- */
          $text_value = esc_attr( $instance['title'] );
          $text_field = array(
            'id'    => $this->get_field_name('title'),
            'name'  => $this->get_field_name('title'),
            'type'  => 'text',
            'title' => __( 'Title', 'chariton' ),
          );
          echo chariton_add_element( $text_field, $text_value );

         
          /* -------------------------------------------------
          /* - All Widget Fields Seiitng
          /*------------------------------------------------- */
          
          /* - About Me Widget Logo Upload Field
          /* ------------------------------------------------- */
          $about_me_widget_logo_value = esc_attr( $instance['about_me_widget_logo'] );
          $about_me_widget_logo_field = array(
            'id'    => $this->get_field_name('about_me_widget_logo'),
            'name'  => $this->get_field_name('about_me_widget_logo'),
            'type'  => 'image',
            'title' => __( 'Logo Image', 'chariton' ),
            'info'  => __( 'About Widghet Logo Upload Here', 'chariton' ),
          );
          echo chariton_add_element( $about_me_widget_logo_field, $about_me_widget_logo_value );

           /* -------------------------------------------------
          /* - Widget Name Seiitng
          /*------------------------------------------------- */
          $about_me_name_value = esc_attr( $instance['about_name'] );
          $about_me_name_field = array(
            'id'    => $this->get_field_name('about_name'),
            'name'  => $this->get_field_name('about_name'),
            'type'  => 'text',
            'title' => __( 'Name', 'chariton' ),
          );
          echo chariton_add_element( $about_me_name_field, $about_me_name_value );

          /* - About widget Button Link
          /* ------------------------------------------------- */
          $about_me_desc_value = esc_attr( $instance['about_me_desc'] );
          $about_me_desc_field = array(
            'id'    => $this->get_field_name('about_me_desc'),
            'name'  => $this->get_field_name('about_me_desc'),
            'type'  => 'textarea',
            'title' => __( 'Description', 'chariton' ),
          );
          echo chariton_add_element( $about_me_desc_field, $about_me_desc_value );

          /* - About widget Button Link
          /* ------------------------------------------------- */
          $social_list_value = esc_attr( $instance['social_list'] );
          $social_list_field = array(
            'id'    => $this->get_field_name('social_list'),
            'name'  => $this->get_field_name('social_list'),
            'type'  => 'textarea',
            'title' => __( 'Social List', 'chariton' ),
          );
          echo chariton_add_element( $social_list_field, $social_list_value );

        }
    }
    // End Of Footer About Widget
}

if ( ! function_exists( 'chariton_about_me_widget_init' ) ) {
  function chariton_about_me_widget_init() {
    register_widget( 'chariton_about_me_Widget' );
  }
  add_action( 'widgets_init', 'chariton_about_me_widget_init', 1 );
}



/*============================================================================================================================*/
/* - Recent Post Widget Widget
/*============================================================================================================================*/ 
if( ! class_exists( 'chariton_recent_post_Widget' ) ) {
  class chariton_recent_post_Widget extends WP_Widget {

    function __construct() {
      $widget_ops     = array(
        'classname'   => 'chariton_rp_widget',
        'description' =>  __( 'Chariton Recent Post Widget.', 'chariton' )
      );

      parent::__construct( 'recent_post_widget', __( 'A::2 Recent Post', 'chariton' ), $widget_ops );
    }

    function widget( $args, $instance ) {

      extract( $args );

      echo $before_widget;

      $title = isset( $instance['title'] ) ? $instance['title'] : '';
      $post_type = isset( $instance['post_type'] ) ? $instance['post_type'] : '';
      $posts_order = isset( $instance['post_order'] ) ? $instance['post_order'] : '';
      $posts_per_page = isset( $instance['post_per_page'] ) ? $instance['post_per_page'] : '';
      $post_title_excerpt = array_key_exists('post_title_excerpt', $instance) ? $instance['post_title_excerpt'] : '';

      // Check if post_title_excerpt is empty or not set, then set a default value
      if (empty($post_title_excerpt)) {
          $post_title_excerpt = 10; // Set a default value
      }

      $post_condition = isset( $instance['post_condition'] ) ? $instance['post_condition'] : '';

      ?> 

      <!-- Footer Blog List
      ========================== -->
      <div class="widget-title mb-35">
          <span></span>
          <h4><?php echo esc_html( $title ); ?></h4>
      </div>

      <div class="sidebar-rc-post">
          <?php
            if ( $post_condition == 'popular' ) {
              $the_query = new WP_Query( array(
                'post_type' => $post_type,
                'posts_per_page' => $posts_per_page,
                'meta_key' => 'post_views_count',
                'orderby' => 'meta_value_num',
              ) );
            } elseif ( $post_condition == 'recent' ) {
              $the_query = new WP_Query( array(
                'post_type' => $post_type,
                'posts_per_page' => $posts_per_page,
                'order' => $posts_order,
              ) );
            } else {
              $the_query = new WP_Query( array(
                'post_type' => $post_type,
                'posts_per_page' => $posts_per_page,
                'order' => $posts_order,
              ) );
            }
            while ( $the_query->have_posts() ) : $the_query->the_post();
          ?>
            <div class="rc-post">
              <?php if(has_post_thumbnail()) { ?>
              <div class="rc-post-thumb">
                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'chariton-thumb-80-80' ); ?></a>
              </div>
              <?php } ?>
              <div class="rc-post-content">
                <h5><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $post_title_excerpt, '' ); ?></a></h5>
                <div class="rc-post-date">
                  <span><i class="fal fa-calendar-alt"></i><?php echo esc_html( get_the_date() ); ?></span>
                </div>
              </div>
            </div>

          <?php endwhile; wp_reset_query(); ?>
      </div>
    <?php echo $after_widget;

    }

    function update( $new_instance, $old_instance ) {
      $instance                       = $old_instance;
      $instance['title']              = $new_instance['title'];
      $instance['post_type']          = $new_instance['post_type'];
      $instance['post_order']         = $new_instance['post_order'];
      $instance['post_per_page']      = $new_instance['post_per_page'];
      $instance['post_title_excerpt'] = $new_instance['post_title_excerpt'];
      $instance['post_condition']     = $new_instance['post_condition'];
      return $instance;
    }

    function form( $instance ) {

      //
      // Title Field Defaults
      // -------------------------------------------------
      $instance       = wp_parse_args( $instance, array(
        'title'              => 'Recent Post',
        'post_per_page'      => '3',
        'post_title_excerpt' => '10',
        'post_type'          => 'post',
        'post_order'         => 'ASC',
        'post_condition'     => 'recent',
      ));

      //
      // Title Field
      // -------------------------------------------------
      $text_value = esc_attr( $instance['title'] );
      $text_field = array(
        'id'    => $this->get_field_name('title'),
        'name'  => $this->get_field_name('title'),
        'type'  => 'text',
        'title' => __( 'Title', 'chariton' ),
      );
      echo chariton_add_element( $text_field, $text_value );

      //
      // Post type
      // -------------------------------------------------
      $post_type_value = esc_attr( $instance['post_type'] );
      $post_type_field = array(
        'id'    => $this->get_field_name('post_type'),
        'name'  => $this->get_field_name('post_type'),
        'type'           => 'select',
        'title'          => __( 'Select Post Type', 'chariton' ),
        'options'        => array(
          'post'         => 'Default Post',
          'events'       => 'Event Post',
        ),
        'default_option' => __( 'Select post type', 'chariton' ),
      );
      echo chariton_add_element( $post_type_field, $post_type_value );

      //
      // Post Order
      // -------------------------------------------------
      $post_order_value = esc_attr( $instance['post_order'] );
      $post_order_field = array(
        'id'    => $this->get_field_name('post_order'),
        'name'  => $this->get_field_name('post_order'),
        'type'   => 'select',
        'title'  => __( 'Select Post Order', 'chariton' ),
        'options' => array(
          'ASC'  => 'Ascending Order',
          'DESC' => 'Descending Post',
        ),
        'default_option' => __( 'Select post order', 'chariton' ),
      );
      echo chariton_add_element( $post_order_field, $post_order_value );

      //
      // Post Per Page
      // -------------------------------------------------
      $post_per_page_value = esc_attr( $instance['post_per_page'] );
      $post_per_page_field = array(
        'id'    => $this->get_field_name('post_per_page'),
        'name'  => $this->get_field_name('post_per_page'),
        'type'  => 'text',
        'title' => __( 'Post Per Page', 'chariton' ),
        'info'  => __( 'How post display here', 'chariton' ),
      );
      echo chariton_add_element( $post_per_page_field, $post_per_page_value );

      //
      // Post Per Page
      // -------------------------------------------------
      $post_title_excerpt_value = esc_attr( $instance['post_title_excerpt'] );
      $post_title_excerpt_field = array(
        'id'    => $this->get_field_name('post_title_excerpt'),
        'name'  => $this->get_field_name('post_title_excerpt'),
        'type'  => 'text',
        'title' => __( 'Post Title Limit', 'chariton' ),
        'info'  => __( 'Post title excerpt', 'chariton' ),
      );
      echo chariton_add_element( $post_title_excerpt_field, $post_title_excerpt_value );

      //
      // Popular or recent ??
      // -------------------------------------------------
      $post_condition_value = esc_attr( $instance['post_condition'] );
      $post_condition_field = array(
        'id'    => $this->get_field_name('post_condition'),
        'name'  => $this->get_field_name('post_condition'),
        'type'   => 'select',
        'title'  => __( 'Recent or Popular?', 'chariton' ),
        'options' => array(
          'recent'  => 'Recent',
          'popular' => 'Popular',
        ),
        'default_option' => __( 'Select post order', 'chariton' ),
      );
      echo chariton_add_element( $post_condition_field, $post_condition_value );

    }
  }
}

if ( ! function_exists( 'chariton_recent_post_widget_init' ) ) {
  function chariton_recent_post_widget_init() {
    register_widget( 'chariton_recent_post_Widget' );
  }
  add_action( 'widgets_init', 'chariton_recent_post_widget_init', 2 );
}


/*============================================================================================================================*/
/* - Newsletter Widget
/*============================================================================================================================*/ 
if( ! class_exists( 'chariton_newsletter_Widget' ) ) {

    //Footer About Widget
    class chariton_newsletter_Widget extends WP_Widget {

        /*=====================================================
        // = Widget Register
        /*=====================================================*/
        function __construct() {

          $widget_ops     = array(
            'classname'   => 'chariton_newsletter_widget',
            'description' => __( 'Chariton Newsletter Widget.', 'chariton' )
          );

          parent::__construct( 'newsletter_widget', __( 'A::3 Newsletter Widget', 'chariton' ), $widget_ops );

        }

        /*=====================================================
        // = Front-end Setting
        /*=====================================================*/
        function widget( $args, $instance ) {

          extract( $args );
          echo $before_widget; ?>

            <?php 
              
              if (!empty($instance['title'])) {
                $title = $instance['title'];
              } else {
                $title = '';
              } if (!empty($instance['newsletter_desc'])) {
                $newsletter_desc = $instance['newsletter_desc'];
              } else {
                $newsletter_desc = '';
              } if (!empty($instance['newsletter_shortcode'])) {
                $newsletter_shortcode = $instance['newsletter_shortcode'];
              } else {
                $newsletter_shortcode = '';
              }
              if (!empty($title)) {
            ?> 
            <div class="fw-title mb-20">
              <h3><?php echo esc_html( $title ); ?></h3>
            </div>
            <?php } ?>
            <div class="fw-newsletter">
              <?php if (!empty($newsletter_desc)) { ?>
                <p><?php echo esc_html( $newsletter_desc ); ?></p>
              <?php } ?>
              <?php echo do_shortcode( $newsletter_shortcode ); ?>
            </div>

          <?php echo $after_widget;
        }
        /*=====================================================
        // = Widget Update Setting
        /*=====================================================*/
        function update( $new_instance, $old_instance ) {

          $instance            = $old_instance;
          $instance['title']   = $new_instance['title'];
          $instance['newsletter_desc']    = $new_instance['newsletter_desc'];
          $instance['newsletter_shortcode']    = $new_instance['newsletter_shortcode'];

          return $instance;

        }

        /*=====================================================
        // = Widget Form Setting
        /*=====================================================*/
        function form( $instance ) {

          /* -------------------------------------------------
          /* - Defaults Value Seiitng Fields
          /*------------------------------------------------- */
          $instance   = wp_parse_args( $instance, array(
            'title' => 'Get Updates',
            'newsletter_desc' => 'Keep up with the latest news of our charity organization.',
            'newsletter_shortcode' => 'Pleae put the newsletter shortcode.',
          ));

          /* -------------------------------------------------
          /* - Widget Title Seiitng
          /*------------------------------------------------- */
          $text_value = esc_attr( $instance['title'] );
          $text_field = array(
            'id'    => $this->get_field_name('title'),
            'name'  => $this->get_field_name('title'),
            'type'  => 'text',
            'title' => __( 'Title', 'chariton' ),
          );
          echo chariton_add_element( $text_field, $text_value );

         
          /* -------------------------------------------------
          /* - All Widget Fields Seiitng
          /*------------------------------------------------- */

          /* - About widget Button Link
          /* ------------------------------------------------- */
          $newsletter_desc_value = esc_attr( $instance['newsletter_desc'] );
          $newsletter_desc_field = array(
            'id'    => $this->get_field_name('newsletter_desc'),
            'name'  => $this->get_field_name('newsletter_desc'),
            'type'  => 'textarea',
            'title' => __( 'Newsletter Description', 'chariton' ),
          );
          echo chariton_add_element( $newsletter_desc_field, $newsletter_desc_value );

          /* - Newsletter Form Shortcode
          /* ------------------------------------------------- */
          $newsletter_shortcode_value = esc_attr( $instance['newsletter_shortcode'] );
          $newsletter_shortcode_field = array(
            'id'    => $this->get_field_name('newsletter_shortcode'),
            'name'  => $this->get_field_name('newsletter_shortcode'),
            'type'  => 'textarea',
            'title' => __( 'Newsletter Form Shortcode', 'chariton' ),
          );
          echo chariton_add_element( $newsletter_shortcode_field, $newsletter_shortcode_value );
         

        }
    }
    // End Of Footer About Widget
}

if ( ! function_exists( 'chariton_newsletter_widget_init' ) ) {
  function chariton_newsletter_widget_init() {
    register_widget( 'chariton_newsletter_Widget' );
  }
  add_action( 'widgets_init', 'chariton_newsletter_widget_init', 3 );
}


/*============================================================================================================================*/
/* - Contact Info Widget
/*============================================================================================================================*/ 
if( ! class_exists( 'chariton_contact_info_Widget' ) ) {

    //Footer Newsletter Widget
    class chariton_contact_info_Widget extends WP_Widget {

        /*=====================================================
        // = Widget Register
        /*=====================================================*/
        function __construct() {

          $widget_ops     = array(
            'classname'   => 'chariton_contact_info_widget',
            'description' => 'Chariton Contact Info List Widget.'
          );
          parent::__construct( 'contact_info_widget', 'A::4 Contact Info List Widget', $widget_ops );

        }

        /*=====================================================
        // = Front-end Setting
        /*=====================================================*/
        function widget( $args, $instance ) {

          extract( $args );
          echo $before_widget; ?>

            <?php 
              $title = $instance['title'];
              $desc = $instance['desc'];
              $contact_phone_icon  = $instance['contact_phone_icon'];
              $contact_phone_title = $instance['contact_phone_title'];
              $contact_phone_text  = $instance['contact_phone_text'];
              $contact_email_icon  = $instance['contact_email_icon'];
              $contact_email_title = $instance['contact_email_title'];
              $contact_email_text  = $instance['contact_email_text'];
              $contact_website_icon  = $instance['contact_website_icon'];
              $contact_website_title = $instance['contact_website_title'];
              $contact_website_text  = $instance['contact_website_text'];

              if ( !empty($instance['contact_widget_logo'])) {
                $image_id = $instance['contact_widget_logo'];
                $attachment = wp_get_attachment_image_src( $image_id, 'full' );
                $image =($attachment) ? $attachment[0] : $image_id;
              } else {
                $image = '';
              }

            ?>
            <?php if (!empty($image)) { ?>
              <div class="footer-logo mb-25">
                <a href="<?php echo esc_url(home_url('/')) ?>"><img src="<?php echo esc_url( $image ); ?>" alt="<?php esc_attr_e( 'footer logo', 'chariton' ); ?>"></a>
              </div>
              <?php }elseif(!empty($title)){ ?>
                <div class="fw-title mb-20"><h3><?php echo esc_html( $title ); ?></h3></div>
              <?php }else{

              } ?>

            <div class="fw-contact">
              <?php if (!empty($desc)) { ?>
                <p><?php echo esc_html( $desc ); ?></p>
              <?php } ?>
              <ul>
                <?php if ( !empty($contact_phone_icon) || !empty($contact_phone_title) || !empty($contact_phone_text )) { ?>
                <li>
                  <?php if ( !empty($contact_phone_icon)) { ?>
                  <div class="fw-contact-icon">
                    <i class="<?php echo esc_attr( $contact_phone_icon ); ?>"></i>
                  </div>
                  <?php } ?>
                  <div class="fw-contact-content">
                    <?php if ( !empty($contact_phone_title)) { ?>
                    <h4><?php echo esc_html( $contact_phone_title ); ?></h4>
                    <?php } if ( !empty($contact_phone_text )) { ?>
                    <a href="tel:<?php echo esc_html( $contact_phone_text ); ?>"><?php echo esc_html( $contact_phone_text ); ?></a>
                    <?php } ?>
                  </div>
                </li>
                <?php } if ( !empty($contact_email_icon) || !empty($contact_email_title) || !empty($contact_email_text )) { ?>
                <li>
                  <?php if ( !empty($contact_email_icon)) { ?>
                  <div class="fw-contact-icon">
                    <i class="<?php echo esc_attr( $contact_email_icon ); ?>"></i>
                  </div>
                  <?php } ?>
                  <div class="fw-contact-content">
                    <?php if ( !empty($contact_email_title)) { ?>
                    <h4><?php echo esc_html( $contact_email_title ); ?></h4>
                    <?php } if ( !empty($contact_email_text)) { ?>
                    <a href="mailto:<?php echo esc_attr( $contact_email_text ); ?>"><?php echo esc_html( $contact_email_text ); ?></a>
                    <?php } ?>
                  </div>
                </li>
                <?php } if ( !empty($contact_website_icon) || !empty($contact_website_title) || !empty($contact_website_text )) { ?>
                <li>
                  <?php if ( !empty($contact_website_icon)) { ?>
                  <div class="fw-contact-icon">
                    <i class="<?php echo esc_attr( $contact_website_icon ); ?>"></i>
                  </div>
                  <?php } ?>
                  <div class="fw-contact-content">
                    <?php if ( !empty($contact_website_title)) { ?>
                    <h4><?php echo esc_attr( $contact_website_title ); ?></h4>
                    <?php } if ( !empty($contact_website_text)) { ?>
                    <a href="<?php echo esc_attr( $contact_website_text ); ?>"><?php echo esc_html( $contact_website_text ); ?></a>
                    <?php } ?>
                  </div>
                </li>
                <?php } ?>
              </ul>
            </div>

          <?php echo $after_widget;

        }
        /*=====================================================
        // = Widget Update Setting
        /*=====================================================*/
        function update( $new_instance, $old_instance ) {

          $instance          = $old_instance;

          $instance['title'] = $new_instance['title'];
          $instance['contact_widget_logo'] = $new_instance['contact_widget_logo'];
          $instance['desc']  = $new_instance['desc'];

          $instance['contact_phone_title'] = $new_instance['contact_phone_title'];
          $instance['contact_phone_text']  = $new_instance['contact_phone_text'];
          $instance['contact_phone_icon']  = $new_instance['contact_phone_icon'];

          $instance['contact_email_title'] = $new_instance['contact_email_title'];
          $instance['contact_email_text']  = $new_instance['contact_email_text'];
          $instance['contact_email_icon']  = $new_instance['contact_email_icon'];

          $instance['contact_website_title'] = $new_instance['contact_website_title'];
          $instance['contact_website_text']  = $new_instance['contact_website_text'];
          $instance['contact_website_icon']  = $new_instance['contact_website_icon'];

          return $instance;

        }

        /*=====================================================
        // = Widget Form Setting
        /*=====================================================*/
        function form( $instance ) {

          /* -------------------------------------------------
          /* - Defaults Value Setting Fields
          /*------------------------------------------------- */
          $instance   = wp_parse_args( $instance, array(

            'title'   => 'Contact info',
            'contact_widget_logo' => CHARITON_PLG_URL. 'assets/imgs/logo3.png',
            'desc'    => '12/A, Road #65, Kelian City United States - 1215',

            'contact_phone_title' => 'Call Us Now',
            'contact_phone_text' => '+987 876 875 76 56 6',
            'contact_phone_icon' => 'fal fa-phone',

            'contact_email_title' => 'Sent An Email',
            'contact_email_text' => 'info@johandemailweb.com',
            'contact_email_icon' => 'fal fa-envelope',

            'contact_website_title' => 'Connect With Us',
            'contact_website_text' => 'www.facebook.com/Johand',
            'contact_website_icon' => 'fab fa-facebook-f',

          ));

          /* -------------------------------------------------
          /* - Widget Title Setting
          /*------------------------------------------------- */
          $text_value = esc_attr( $instance['title'] );
          $text_field = array(
            'id'    => $this->get_field_name('title'),
            'name'  => $this->get_field_name('title'),
            'type'  => 'text',
            'title' => 'Title',
          );
          echo chariton_add_element( $text_field, $text_value );

          /* - About Me Widget Logo Upload Field
          /* ------------------------------------------------- */
          $contact_widget_logo_value = esc_attr( $instance['contact_widget_logo'] );
          $contact_widget_logo_field = array(
            'id'    => $this->get_field_name('contact_widget_logo'),
            'name'  => $this->get_field_name('contact_widget_logo'),
            'type'  => 'image',
            'title' => __( 'Logo Image', 'chariton' ),
            'info'  => __( 'About Widghet Logo Upload Here', 'chariton' ),
          );
          echo chariton_add_element( $contact_widget_logo_field, $contact_widget_logo_value );


          /* -------------------------------------------------
          /* - Widget Title Setting
          /*------------------------------------------------- */
          $text_value = esc_attr( $instance['desc'] );
          $text_field = array(
            'id'    => $this->get_field_name('desc'),
            'name'  => $this->get_field_name('desc'),
            'type'  => 'textarea',
            'title' => 'Description',
          );
          echo chariton_add_element( $text_field, $text_value );

         
          /* -------------------------------------------------
          /* - All Widget Fields Seiitng
          /*------------------------------------------------- */

          /* - Contact Phone Icon
          /* ------------------------------------------------- */
          $contact_phone_icon_value = esc_attr( $instance['contact_phone_icon'] );
          $contact_phone_icon_field = array(
            'id'    => $this->get_field_name('contact_phone_icon'),
            'name'  => $this->get_field_name('contact_phone_icon'),
            'type'  => 'icon',
            'title' => 'Contact Phone Icon',
          );
          echo chariton_add_element( $contact_phone_icon_field, $contact_phone_icon_value );

          /* - Contact Phone Title
          /* ------------------------------------------------- */
          $contact_phone_title_value = esc_attr( $instance['contact_phone_title'] );
          $contact_phone_title_field = array(
            'id'    => $this->get_field_name('contact_phone_title'),
            'name'  => $this->get_field_name('contact_phone_title'),
            'type'  => 'text',
            'title' => 'Contact Phone Title',
          );
          echo chariton_add_element( $contact_phone_title_field, $contact_phone_title_value );

          /* - Contact Phone Text
          /* ------------------------------------------------- */
          $contact_phone_text_value = esc_attr( $instance['contact_phone_text'] );
          $contact_phone_text_field = array(
            'id'    => $this->get_field_name('contact_phone_text'),
            'name'  => $this->get_field_name('contact_phone_text'),
            'type'  => 'textarea',
            'title' => 'Contact Phone Text',
          );
          echo chariton_add_element( $contact_phone_text_field, $contact_phone_text_value );

          /* - Contact Email Icon
          /* ------------------------------------------------- */
          $contact_email_icon_value = esc_attr( $instance['contact_email_icon'] );
          $contact_email_icon_field = array(
            'id'    => $this->get_field_name('contact_email_icon'),
            'name'  => $this->get_field_name('contact_email_icon'),
            'type'  => 'icon',
            'title' => 'Contact Email Icon',
          );
          echo chariton_add_element( $contact_email_icon_field, $contact_email_icon_value );

          /* - Contact Info 2 Title
          /* ------------------------------------------------- */
          $contact_email_title_value = esc_attr( $instance['contact_email_title'] );
          $contact_email_title_field = array(
            'id'    => $this->get_field_name('contact_email_title'),
            'name'  => $this->get_field_name('contact_email_title'),
            'type'  => 'text',
            'title' => 'Contact Email Title',
          );
          echo chariton_add_element( $contact_email_title_field, $contact_email_title_value );

          /* - Contact Email Text
          /* ------------------------------------------------- */
          $contact_email_text_value = esc_attr( $instance['contact_email_text'] );
          $contact_email_text_field = array(
            'id'    => $this->get_field_name('contact_email_text'),
            'name'  => $this->get_field_name('contact_email_text'),
            'type'  => 'textarea',
            'title' => 'Contact Email Text',
          );
          echo chariton_add_element( $contact_email_text_field, $contact_email_text_value );


          /* - Contact Info 3 Icon
          /* ------------------------------------------------- */
          $contact_website_icon_value = esc_attr( $instance['contact_website_icon'] );
          $contact_website_icon_field = array(
            'id'    => $this->get_field_name('contact_website_icon'),
            'name'  => $this->get_field_name('contact_website_icon'),
            'type'  => 'icon',
            'title' => 'Contact Website Icon',
          );
          echo chariton_add_element( $contact_website_icon_field, $contact_website_icon_value );

          /* - Contact Website Title
          /* ------------------------------------------------- */
          $contact_website_title_value = esc_attr( $instance['contact_website_title'] );
          $contact_website_title_field = array(
            'id'    => $this->get_field_name('contact_website_title'),
            'name'  => $this->get_field_name('contact_website_title'),
            'type'  => 'text',
            'title' => 'Contact Website Title',
          );
          echo chariton_add_element( $contact_website_title_field, $contact_website_title_value );

          /* - Contact Website Text
          /* ------------------------------------------------- */
          $contact_website_text_value = esc_attr( $instance['contact_website_text'] );
          $contact_website_text_field = array(
            'id'    => $this->get_field_name('contact_website_text'),
            'name'  => $this->get_field_name('contact_website_text'),
            'type'  => 'textarea',
            'title' => 'Contact Website Address',
          );
          echo chariton_add_element( $contact_website_text_field, $contact_website_text_value );

        }
    }
    // End Of Footer About Widget
}

if ( ! function_exists( 'chariton_contact_info_widget_init' ) ) {
  function chariton_contact_info_widget_init() {
    register_widget( 'chariton_contact_info_Widget' );
  }
  add_action( 'widgets_init', 'chariton_contact_info_widget_init', 4 );
}

/*============================================================================================================================*/
/* - Donate count Widget
/*============================================================================================================================*/ 
if( ! class_exists( 'chariton_donate_count_Widget' ) ) {

    //Footer About Widget
    class chariton_donate_count_Widget extends WP_Widget {

        /*=====================================================
        // = Widget Register
        /*=====================================================*/
        function __construct() {

          $widget_ops     = array(
            'classname'   => 'chariton_donate_count_widget',
            'description' => __( 'Chariton Doante Count.', 'chariton' )
          );

          parent::__construct( 'donate_count_widget', __( 'A::5 Doante Count', 'chariton' ), $widget_ops );

        }

        /*=====================================================
        // = Front-end Setting
        /*=====================================================*/
        function widget( $args, $instance ) {

          extract( $args );
          echo $before_widget; ?>

            <?php 
              
              if (!empty($instance['form_goal_id'])) {
                $form_goal_id = $instance['form_goal_id'];
              } else {
                $form_goal_id = '';
              } if (!empty($instance['social_counts'])) {
                $social_counts = $instance['social_counts'];
              } else {
                $social_counts = '';
              } if (!empty($instance['donate_btn_txt'])) {
                $donate_btn_txt = $instance['donate_btn_txt'];
              } else {
                $donate_btn_txt = '';
              } if (!empty($instance['donate_btn_link'])) {
                $donate_btn_link = $instance['donate_btn_link'];
              } else {
                $donate_btn_link = '';
              } if (!empty($instance['share_btn_txt'])) {
                $share_btn_txt = $instance['share_btn_txt'];
              } else {
                $share_btn_txt = '';
              } if (!empty($instance['share_btn_link'])) {
                $share_btn_link = $instance['share_btn_link'];
              } else {
                $share_btn_link = '';
              }
              if (!empty($form_goal_id)) {
            ?>

            <div class="target-progress-range mb-15">
              <?php echo do_shortcode('[give_goal id="'.$form_goal_id.'" show_text="true" show_bar="true"]') ?>
            </div>
            <?php } ?>
            <div class="cause-target-meta mb-25">
              <?php echo $social_counts; ?>
            </div>
            <?php if (!empty($donate_btn_link) || !empty($share_btn_link)) { ?>
            <div class="cause-sidebar-btn">
              <?php if (!empty($donate_btn_link)) { ?>
              <a href="<?php echo esc_url( $donate_btn_link ); ?>" class="btn donate-btn"><i class="fas fa-heart"></i><?php echo esc_html( $donate_btn_txt ); ?></a>
              <?php } if (!empty($share_btn_link)) { ?>
              <a href="<?php echo esc_url( $share_btn_link ); ?>" class="btn share-btn"><i class="fas fa-share"></i><?php echo esc_html( $share_btn_txt ); ?></a>
              <?php } ?>
            </div>
            <?php } ?>

          <?php echo $after_widget;
        }
        /*=====================================================
        // = Widget Update Setting
        /*=====================================================*/
        function update( $new_instance, $old_instance ) {

          $instance            = $old_instance;
          $instance['form_goal_id']    = $new_instance['form_goal_id'];
          $instance['social_counts']   = $new_instance['social_counts'];
          $instance['donate_btn_txt']  = $new_instance['donate_btn_txt'];
          $instance['donate_btn_link'] = $new_instance['donate_btn_link'];
          $instance['share_btn_txt']   = $new_instance['share_btn_txt'];
          $instance['share_btn_link']  = $new_instance['share_btn_link'];

          return $instance;

        }

        /*=====================================================
        // = Widget Form Setting
        /*=====================================================*/
        function form( $instance ) {

          /* -------------------------------------------------
          /* - Defaults Value Seiitng Fields
          /*------------------------------------------------- */
          $instance   = wp_parse_args( $instance, array(
            'form_goal_id' => '1230',
            'social_counts' => '<ul><li><h6>2.1K</h6><span>Donors</span></li></ul>',
            'donate_btn_txt' => 'Make Donation',
            'donate_btn_link' => '#',
            'share_btn_txt' => 'Share Post',
            'share_btn_link' => '#',
          ));

          /* -------------------------------------------------
          /* - Cause target
          /*------------------------------------------------- */
          $form_goal_id_value = esc_attr( $instance['form_goal_id'] );
          $form_goal_id_field = array(
            'id'       => $this->get_field_name('form_goal_id'),
            'name'     => $this->get_field_name('form_goal_id'),
            'type'     => 'text',
            'title'    => __( 'Form Goal Id', 'chariton' ),
          );
          echo chariton_add_element( $form_goal_id_field, $form_goal_id_value );

          /* -------------------------------------------------
          /* - Social Counts
          /*------------------------------------------------- */
          $social_counts_value = esc_attr( $instance['social_counts'] );
          $social_counts_field = array(
            'id'    => $this->get_field_name('social_counts'),
            'name'  => $this->get_field_name('social_counts'),
            'type'  => 'textarea',
            'title' => __( 'Social Counts', 'chariton' ),
          );
          echo chariton_add_element( $social_counts_field, $social_counts_value );

          /* -------------------------------------------------
          /* - Donate button title
          /*------------------------------------------------- */
          $donate_btn_txt_value = esc_attr( $instance['donate_btn_txt'] );
          $donate_btn_txt_field = array(
            'id'    => $this->get_field_name('donate_btn_txt'),
            'name'  => $this->get_field_name('donate_btn_txt'),
            'type'  => 'text',
            'title' => __( 'Donate button title', 'chariton' ),
          );
          echo chariton_add_element( $donate_btn_txt_field, $donate_btn_txt_value );

          /* -------------------------------------------------
          /* - Donate button link
          /*------------------------------------------------- */
          $donate_btn_link_value = esc_attr( $instance['donate_btn_link'] );
          $donate_btn_link_field = array(
            'id'    => $this->get_field_name('donate_btn_link'),
            'name'  => $this->get_field_name('donate_btn_link'),
            'type'  => 'text',
            'title' => __( 'Donate button link', 'chariton' ),
          );
          echo chariton_add_element( $donate_btn_link_field, $donate_btn_link_value );

          /* -------------------------------------------------
          /* - Share button title
          /*------------------------------------------------- */
          $share_btn_txt_value = esc_attr( $instance['share_btn_txt'] );
          $share_btn_txt_field = array(
            'id'    => $this->get_field_name('share_btn_txt'),
            'name'  => $this->get_field_name('share_btn_txt'),
            'type'  => 'text',
            'title' => __( 'Share button title', 'chariton' ),
          );
          echo chariton_add_element( $share_btn_txt_field, $share_btn_txt_value );

          /* -------------------------------------------------
          /* - Share button link
          /*------------------------------------------------- */
          $share_btn_link_value = esc_attr( $instance['share_btn_link'] );
          $share_btn_link_field = array(
            'id'    => $this->get_field_name('share_btn_link'),
            'name'  => $this->get_field_name('share_btn_link'),
            'type'  => 'text',
            'title' => __( 'Share button link', 'chariton' ),
          );
          echo chariton_add_element( $share_btn_link_field, $share_btn_link_value );

        }
    }
    // End Of Footer About Widget
}

if ( ! function_exists( 'chariton_donate_count_widget_init' ) ) {
  function chariton_donate_count_widget_init() {
    register_widget( 'chariton_donate_count_Widget' );
  }
  add_action( 'widgets_init', 'chariton_donate_count_widget_init', 5 );
}


/*============================================================================================================================*/
/* - Dodors Post Widget Widget
/*============================================================================================================================*/ 
if( ! class_exists( 'chariton_donors_post_Widget' ) ) {
  class chariton_donors_post_Widget extends WP_Widget { 

    function __construct() {

      $widget_ops     = array(
        'classname'   => 'chariton_donors_widget',
        'description' =>  __( 'Donors Post Widget.', 'chariton' )
      );

      parent::__construct( 'donors_post_widget', __( 'A::6 Donors Post', 'chariton' ), $widget_ops );

    }

    function widget( $args, $instance ) {

      extract( $args );

      echo $before_widget;

      if ( ! class_exists( 'Give_Payments_Query' ) ) {
        return;
      }

      $title = $instance['title'];
      $posts_per_page = $instance['post_per_page'];
      $more_btn_txt   = $instance['more_btn_txt'];
      $more_btn_link  = $instance['more_btn_link'];

      $args = array(
        'output' => 'payments',
        'number' => $posts_per_page,
        'status' => 'publish',
      );

      $payments = new Give_Payments_Query( $args );
      $payments = $payments->get_payments();

      if ( $payments ) {
    ?> 

      <!-- Footer Blog List
      ========================== -->
      <div class="cause-donor-list">
        <?php if (!empty($title)) { ?>
          <h3 class="mb-20"><?php echo esc_html( $title ); ?></h3>
        <?php } ?>
        <ul>
          <?php
            foreach ( $payments as $payment ) {
            $first_name = $payment->get_meta( '_give_donor_billing_first_name', true );
            $last_name = $payment->get_meta( '_give_donor_billing_last_name', true );

            $total  = give_donation_amount( $payment->ID, array( 'currency' => true ) );
            $avatar = get_avatar( $payment->email, 64 );

          ?>
            <li>
              <div class="c-donor-thumb">
                <a href="<?php the_permalink(); ?>"><?php echo $avatar; ?></a>
              </div>
              <div class="c-donor-content">
                <h5><a href="<?php the_permalink(); ?>"><?php echo esc_html( $first_name . ' ' . $last_name ); ?></a></h5>
                <p><?php echo esc_html( $total ); ?> <span><i class="far fa-clock"></i><?php echo esc_html( date( "F j, Y", strtotime( $payment->date ) ) ); ?></span></p>
              </div>
            </li>
          <?php } ?>
        </ul>
      </div>
      <?php if (!empty($more_btn_link)) { ?>
      <div class="donor-more mt-35 text-center">
        <a href="<?php echo esc_url( $more_btn_link ); ?>" class="btn"><?php echo esc_html( $more_btn_txt ); ?></a>
      </div>

      <?php } } else { ?>
        <div class="cause-donor-list">
          <h4><?php esc_html_e( 'There have no donor list', 'chariton' ); ?></h4>
        </div>
      <?php } ?>

    <?php echo $after_widget;

    }

    function update( $new_instance, $old_instance ) {

      $instance            = $old_instance;
      $instance['title']   = $new_instance['title'];
      $instance['post_order']     = $new_instance['post_order'];
      $instance['post_per_page']  = $new_instance['post_per_page'];
      $instance['more_btn_txt']  = $new_instance['more_btn_txt'];
      $instance['more_btn_link']  = $new_instance['more_btn_link'];

      return $instance;

    }

    function form( $instance ) {

      //
      // Title Field Defaults
      // -------------------------------------------------
      $instance       = wp_parse_args( $instance, array(
        'title'         => 'Donors Post',
        'post_per_page' => '-1',
        'more_btn_txt'  => 'See All +',
        'more_btn_link' => '#',
      ));

      //
      // Title Field
      // -------------------------------------------------
      $text_value = esc_attr( $instance['title'] );
      $text_field = array(
        'id'    => $this->get_field_name('title'),
        'name'  => $this->get_field_name('title'),
        'type'  => 'text',
        'title' => __( 'Title', 'chariton' ),
      );
      echo chariton_add_element( $text_field, $text_value );

      //
      // Post Per Page
      // -------------------------------------------------
      $post_per_page_value = esc_attr( $instance['post_per_page'] );
      $post_per_page_field = array(
        'id'    => $this->get_field_name('post_per_page'),
        'name'  => $this->get_field_name('post_per_page'),
        'type'  => 'text',
        'title' => __( 'Post Per Page', 'chariton' ),
        'info'  => __( 'How post display here', 'chariton' ),
      );
      echo chariton_add_element( $post_per_page_field, $post_per_page_value );

      //
      // More button text
      // -------------------------------------------------
      $more_btn_txt_value = esc_attr( $instance['more_btn_txt'] );
      $more_btn_txt_field = array(
        'id'    => $this->get_field_name('more_btn_txt'),
        'name'  => $this->get_field_name('more_btn_txt'),
        'type'  => 'text',
        'title' => __( 'More button text', 'chariton' ),
      );
      echo chariton_add_element( $more_btn_txt_field, $more_btn_txt_value );

      //
      // More button link
      // -------------------------------------------------
      $more_btn_link_value = esc_attr( $instance['more_btn_link'] );
      $more_btn_link_field = array(
        'id'    => $this->get_field_name('more_btn_link'),
        'name'  => $this->get_field_name('more_btn_link'),
        'type'  => 'text',
        'title' => __( 'More button link', 'chariton' ),
      );
      echo chariton_add_element( $more_btn_link_field, $more_btn_link_value );

    }
  }
}

if ( ! function_exists( 'chariton_donors_post_widget_init' ) ) {
  function chariton_donors_post_widget_init() {
    register_widget( 'chariton_donors_post_Widget' );
  }
  add_action( 'widgets_init', 'chariton_donors_post_widget_init', 6 );
}


/*------------------------------------------------------------------------------------------*/
/* - Contact Info Widget
/*------------------------------------------------------------------------------------------*/
if( ! class_exists( 'chariton_socialprofile_Widget' ) ) {

  //Footer Newsletter Widget
  class chariton_socialprofile_Widget extends WP_Widget {

    function __construct(){
        $widget_ops = array(
          'classname' => 'chariton_social_profile_widget',
          'description' => esc_html__('Social Profile Widgets.', 'chariton')
        );
        parent::__construct( 'about_us_widget', esc_html__('A::7 Social Widget', 'chariton'), $widget_ops);
    }

    /* = Front-end Setting
    /*=====================================================*/
    function widget( $args, $instance ) {

      extract( $args );
      echo $before_widget;
      $title        = $instance['title'];
      $social_list1 = $instance['social_list1'];
      $social_list2 = $instance['social_list2'];
      $social_list3 = $instance['social_list3'];
      $social_list4 = $instance['social_list4'];
      $social_list5 = $instance['social_list5'];
      ?>
      
      <div class="social-profile-widget">
        <?php if ( !empty( $title ) ) { ?>
          <div class="widget-title mb-35">
            <h4><?php echo $title; ?></h4>
          </div>
        <?php } ?>
        <div class="footer-social">
          <ul>
          <?php if ( !empty( $social_list1 ) ) { ?>
             <li><a href="<?php echo $social_list1; ?>" class="facebook"><i class="fab fa-facebook-f"></i></a></li>
          <?php } ?>
          <?php if ( !empty( $social_list2 ) ) { ?>
             <li><a href="<?php echo $social_list2; ?>" class="twitter"><i class="fab fa-twitter"></i></a></li>
          <?php } ?>
          <?php if ( !empty( $social_list3 ) ) { ?>
             <li><a href="<?php echo $social_list3; ?>" class="instagram"><i class="fab fa-pinterest"></i></a></li>
          <?php } ?>
          <?php if ( !empty( $social_list4 ) ) { ?>
             <li><a href="<?php echo $social_list4; ?>" class="pinterest"><i class="fab fa-behance"></i></a></li>
          <?php } ?>
          <?php if ( !empty( $social_list5 ) ) { ?>
             <li><a href="<?php echo $social_list5; ?>" class="pinterest"><i class="fab fa-youtube"></i></a></li>
          <?php } ?>
          </ul>
        </div>
      </div>

      <?php echo $after_widget;
    }

    /* = Widget Update Setting
    /*=====================================================*/
    function update( $new_instance, $old_instance ) {
      $instance                 = $old_instance;
      $instance['title']        = $new_instance['title'];
      $instance['social_list1'] = $new_instance['social_list1'];
      $instance['social_list2'] = $new_instance['social_list2'];
      $instance['social_list3'] = $new_instance['social_list3'];
      $instance['social_list4'] = $new_instance['social_list4'];
      $instance['social_list5'] = $new_instance['social_list5'];
      return $instance;
    }

    /* = Widget Form Setting
    /*=====================================================*/
    function form( $instance ) {
        $defaults = array(
            'title'                => 'Social Info',
            'social_list1'       => '#',
            'social_list2'       => '#',
            'social_list3'       => '#',
            'social_list4'       => '#',
            'social_list5'       => '#',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'chariton'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('social_list1'); ?>">
                <?php esc_html_e('Social (Facebook):', 'chariton'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('social_list1'); ?>" name="<?php echo $this->get_field_name('social_list1'); ?>" type="text" value="<?php echo $instance['social_list1']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('social_list2'); ?>">
                <?php esc_html_e('Social (twitter):', 'chariton'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('social_list2'); ?>" name="<?php echo $this->get_field_name('social_list2'); ?>" type="text" value="<?php echo $instance['social_list2']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('social_list3'); ?>">
                <?php esc_html_e('Social (instagram):', 'chariton'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('social_list3'); ?>" name="<?php echo $this->get_field_name('social_list3'); ?>" type="text" value="<?php echo $instance['social_list3']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('social_list4'); ?>">
                <?php esc_html_e('Social (pinterest):', 'chariton'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('social_list4'); ?>" name="<?php echo $this->get_field_name('social_list4'); ?>" type="text" value="<?php echo $instance['social_list4']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('social_list5'); ?>">
                <?php esc_html_e('Social (Youtube):', 'chariton'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('social_list5'); ?>" name="<?php echo $this->get_field_name('social_list5'); ?>" type="text" value="<?php echo $instance['social_list5']; ?>" />
            </label>
        </p>
      <?php
    }

  }
}

if ( ! function_exists( 'chariton_social_profile_widget_init' ) ) {
  function chariton_social_profile_widget_init() {
    register_widget( 'chariton_socialprofile_Widget' );
  }
  add_action( 'widgets_init', 'chariton_social_profile_widget_init', 3 );
}
