<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/*------------------------------------------------------------------------------------------------------------------*/
/*  Page loading
/*------------------------------------------------------------------------------------------------------------------*/ 
function chariton_page_loader() { ?>
    <!-- loading  -->
    <div id="preloader">
        <div id="loading-center">
            <div id="loading-center-absolute">
                <div class="object" id="object_one"></div>
                <div class="object" id="object_two"></div>
                <div class="object" id="object_three"></div>
            </div>
        </div>
    </div>
    <!-- loading end -->
<?php }
add_action('chariton_preloading', 'chariton_page_loader');

/*------------------------------------------------------------------------------------------------------------------*/
/*  Scroll to top
/*------------------------------------------------------------------------------------------------------------------*/ 
function chariton_scroll_to_top() {  ?>
    <div id="scroller">
        <i class="far fa-level-up" aria-hidden="true"></i>
    </div>
    <?php 
}
add_action('chariton_scrollup', 'chariton_scroll_to_top');

/*------------------------------------------------------------------------------------------------------------------*/
/*  Chariton Socials Share Buttons
/*------------------------------------------------------------------------------------------------------------------*/ 
add_action('chariton_social_share_media', 'chariton_social_share_media_btns');
function chariton_social_share_media_btns() { ?>
    <div class="cause-details-share">
        <h5><?php esc_html_e( 'Social Share:', 'chariton' ); ?></h5>
        <ul>
            <li><a href="http://www.facebook.com/sharer.php?u=<?php the_permalink();?>&amp;t=<?php the_title(); ?>" title="Share this post on Facebook!" onclick="window.open(this.href); return false;" class="facebook"><i class="fab fa-facebook-f"></i></a></li>
            <li><a href="http://twitter.com/home?status=Reading: <?php the_permalink(); ?>" title="Share this post on Twitter!" target="_blank" class="twitter"><i class="fab fa-twitter"></i></a></li>
            <li><a data-pin-do="buttonPin" href="https://www.pinterest.com/pin/create/button/?url=<?php the_permalink();?>" data-pin-custom="true" target="_blank" class="pinterest"><i class="fab fa-pinterest-p"></i></a></li>
            <li><a href="javascript:void(0)" onclick="window.open( 'https://www.linkedin.com/share?url=<?php the_permalink(); ?>', 'sharer', 'toolbar=0, status=0, width=626, height=436');return false;" title="Linkdin"><span class="character"><i class="fab fa-linkedin-in"></i></span></a></li>
        </ul>
    </div>
<?php }

/*------------------------------------------------------------------------------------------------------------------*/
/*  Header Search form 
/*------------------------------------------------------------------------------------------------------------------*/ 
add_action('chariton_search_form_modal', 'chariton_header_search_form');
function chariton_header_search_form() { ?>
    <div class="modal fade" id="search-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
              <form action="<?php echo esc_url(home_url('/')); ?>" method="get">
                <input type="text" name="s" placeholder="<?php esc_attr__( 'Search here...', 'chariton' ); ?>">
                <button><i class="fa fa-search"></i></button>
            </form>
        </div>
    </div>
</div>
<?php }

/*------------------------------------------------------------------------------------------------------------------*/
/*  Header Login form 
/*------------------------------------------------------------------------------------------------------------------*/ 
add_action('chariton_login_form', 'chariton_header_login_form');
function chariton_header_login_form() { ?>
    <div class="modal fade" id="login-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <?php 
                global $user_ID;
                if(empty($user_ID)) { ?>                
                    <h5><?php esc_html_e( 'You are now logged out.', 'chariton' ); ?></h5>
                    <!-- Modal Content -->
                    <form class="modal-content animate" action="<?php echo site_url( '/wp-login.php' ); ?>" method="post">
                        <div class="login-form-body">
                            <input class="form-control" type="text" name="log" id="user_login" placeholder="Username" required>
                            <input class="form-control" type="password" name="pwd" id="user_pass" placeholder="Password" required>
                            <button class="form-btn btn" type="submit"><?php esc_html_e( 'Login', 'chariton' ); ?></button>

                            <div class="remember">
                                <div class="remember-me">
                                    <input type="checkbox" checked="checked"> 
                                    <label for="check"><?php esc_html_e( 'Remember me', 'chariton' ); ?></label>
                                </div>
                                <div class="remember-me">
                                    <input type="checkbox" id="check">
                                    <label for="check"><?php esc_html_e( 'Remember password ?', 'chariton' ); ?></label>
                                </div>
                            </div>
                        </div>

                        <div class="form-footer">
                            <span class="forget-psw"><a href="<?php echo wp_lostpassword_url(); ?>"><?php esc_html_e( 'Lost Your password ?', 'chariton' ); ?></a></span>
                            <span class="back-to-site">
                                <a href="<?php echo esc_url( home_url('/') ); ?>"><?php esc_html_e( '← Back to Site', 'chariton' ) . ' '. get_bloginfo( 'name' ); ?></a>
                            </span>
                        </div>
                    </form>
                <?php } else { ?>
                    <h4><?php esc_html_e( 'You Are Already Logged In', 'chariton' ); ?></h4>
                <?php } 
                ?>
            </div>
        </div>
    </div>
<?php }

/*------------------------------------------------------------------------------------------------------------------*/
/*  Header Toggle Menu
/*------------------------------------------------------------------------------------------------------------------*/ 
add_action('chariton_toggle_menu_modal', 'chariton_header_toggle_menu');
function chariton_header_toggle_menu() {
    $menu_toggle_btn = chariton_get_option('top_header4_toggle');
    if ( !empty($menu_toggle_btn) ) { 
        $canvas_social_btn = chariton_get_option('header4_tm_socials');
        ?>
        <div class="offcanvas-menu">
            <span class="menu-close"><i class="fa fa-times"></i></span>
            <?php dynamic_sidebar( 'offcanvas-sidebar' ); ?>
            <?php if (is_array($canvas_social_btn)) { ?>
                <div class="side-social">
                  <?php foreach ($canvas_social_btn as $key => $value) { ?>
                      <a href="<?php echo esc_url( $value['link'] ); ?>"><i class="<?php echo esc_attr( $value['icon'] ); ?>"></i></a>
                  <?php } ?>
              </div>
          <?php } ?>
      </div>
      <div class="offcanvas-overly"></div>
  <?php } 
}

  /*------------------------------------------------------------------------------------------------------------------*/
/*  Shortcode for language
/*------------------------------------------------------------------------------------------------------------------*/
function multi_lingual_shortcodecode($atts, $content=null) {
    extract(shortcode_atts( array(
        'lan' => '',
    ), $atts));

    $html='';

    $html.='<div class="header-lang d-inline-block"><ul>
    <li><a href="#">'.esc_html__( 'EN', 'chariton' ).'</a></li>
    <li><a href="#">'.esc_html__( 'WH', 'chariton' ).'</a></li>
    <li><a href="#">'.esc_html__( 'NZ', 'chariton' ).'</a></li>
    <li><a href="#">'.esc_html__( 'IN', 'chariton' ).'</a></li>
    </ul></div>';

    return $html;

}
add_shortcode('charitonlang', 'multi_lingual_shortcodecode');


/*------------------------------------------------------------------------------------------------------------------*/
/*  W3C validator passing code
/*------------------------------------------------------------------------------------------------------------------*/
add_action( 'template_redirect', function(){
    ob_start( function( $buffer ){
        $buffer = str_replace( array( '<script type="text/javascript">', "<script type='text/javascript'>" ), '<script>', $buffer );
        return $buffer;
    });
});
add_action( 'template_redirect', function(){
    ob_start( function( $buffer2 ){
        $buffer2 = str_replace( array( "<script type='text/javascript' src" ), '<script src', $buffer2 );
        return $buffer2;
    });
});
add_action( 'template_redirect', function(){
    ob_start( function( $buffer3 ){
        $buffer3 = str_replace( array( 'type="text/css"', "type='text/css'", 'type="text/css"', ), '', $buffer3 );
        return $buffer3;
    });
});


/*------------------------------------------------------------------------------------------------------------------*/
/*  Inline Style code
/*------------------------------------------------------------------------------------------------------------------*/
global $all_inline_styles;
$all_inline_styles = array();
if( ! function_exists( 'add_inline_style' ) ) {
  function add_inline_style( $style ) {
    global $all_inline_styles;
    array_push( $all_inline_styles, $style );
}
}

/* Enqueue Inline Styles */
if ( ! function_exists( 'chariton_enqueue_inline_styles' ) ) {
  function chariton_enqueue_inline_styles() {
    global $all_inline_styles;
    if ( ! empty( $all_inline_styles ) ) {
      echo '<style id="chariton-inline-style">'. join( '', $all_inline_styles ) .'</style>';
  }
}
add_action( 'wp_head', 'chariton_enqueue_inline_styles' );
}

/*------------------------------------------------------------------------------------------------------------------*/
/*  Custom shortode
/*------------------------------------------------------------------------------------------------------------------*/
function revo_slide_btn_shortcode($atts, $content=null) {
    extract(shortcode_atts( array(
        'url'   => '', 
        'url2'  => '', 
        'text'  => 'Read More',
        'text2' => 'Our Approach',
    ), $atts));

    $html='';

    if(!empty($url && $url2 )){
        $html.='<div class="slider-btn">';
        $html.='<a href="'.esc_url($url).'" class="btn s-btn wow fadeInLeft" data-wow-delay="1.5s">'.esc_html($text).'</a>';
        $html.='<a href="'.esc_url($url2).'" class="btn s-btn transparent-btn wow fadeInRight" data-wow-delay="1.5s">'.esc_html($text2).'</a>';
        $html.='</div>';
    } elseif(!empty($url)){
        $html.='<div class="slider-btn">';
        $html.='<a href="'.esc_url($url).'" class="btn s-btn wow fadeInLeft" data-wow-delay="1.5s">'.esc_html($text).'</a>';
        $html.='</div>';
    } elseif (!empty($url2)) {
        $html.='<div class="slider-btn">';
        $html.='<a href="'.esc_url($url2).'" class="btn s-btn transparent-btn wow fadeInRight" data-wow-delay="1.5s">'.esc_html($text2).'</a>';
        $html.='</div>';
    } else {
     $html.='<div class="slider-btn">';
     $html.='<a href="'.esc_url($url).'" class="btn s-btn wow fadeInLeft" data-wow-delay="1.5s">'.esc_html($text).'</a>';
     $html.='<a href="'.esc_url($url2).'" class="btn s-btn transparent-btn wow fadeInRight" data-wow-delay="1.5s">'.esc_html($text2).'</a>';
     $html.='</div>';
 }

 return $html;

}
add_shortcode('charitonbtn', 'revo_slide_btn_shortcode');