<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
* Define chariton class
*/
class Chariton_Master_Core {


	/* =================================================================
    = Breadcrumb settings
    ====================================================================*/
	public function Breadcrumb_Settings() {

  		if(function_exists( 'chariton_framework_init' ) ) {
  			// Breadcrumb settings
		    $breadcrumb_bg_condition = chariton_get_option( 'breadcrumb_bg_condition' );

		    $breadcrumb_bg_color = chariton_get_option( 'breadcrumb_bg_color' );
		    if (!empty($breadcrumb_bg_color)) {
		      $breadcrumb_bg_color = $breadcrumb_bg_color;
		    } else {
		      $breadcrumb_bg_color = '# ';
		    }

		    $breatcrumb_font_color = chariton_get_option( 'breatcrumb_font_color' );
		    if (!empty($breatcrumb_font_color)) {
		      $breatcrumb_font_color = $breatcrumb_font_color;
		    } else {
		      $breatcrumb_font_color = '#fff';
		    }
		    $breatcrumb_hover_link_color = chariton_get_option( 'breatcrumb_hover_link_color' );
		    if (!empty($breatcrumb_hover_link_color)) {
		      $breatcrumb_hover_link_color = $breatcrumb_hover_link_color;
		    } else {
		      $breatcrumb_hover_link_color = '#ff566e';
		    }
		    
		    $breatcrumb_pt = chariton_get_option( 'breatcrumb_pt' );
		    if (!empty($breatcrumb_pt)) {
		      $breatcrumb_pt = $breatcrumb_pt;
		    } else {
		      $breatcrumb_pt = '140px';
		    }

		    $breatcrumb_pb = chariton_get_option( 'breatcrumb_pb' );
		    if (!empty($breatcrumb_pb)) {
		      $breatcrumb_pb = $breatcrumb_pb;
		    } else {
		      $breatcrumb_pb = '135px';
		    }

		    $chariton_breadcrumb_font_weight = chariton_get_option( 'chariton_breadcrumb_font_weight' );
		    if (!empty($chariton_breadcrumb_font_weight)) {
		      $chariton_breadcrumb_font_weight = $chariton_breadcrumb_font_weight;
		    } else {
		      $chariton_breadcrumb_font_weight = '500';
		    }

		    $chariton_breadcrumb_text_transform = chariton_get_option( 'chariton_breadcrumb_text_transform' );
		    if (!empty($chariton_breadcrumb_text_transform)) {
		      $chariton_breadcrumb_text_transform = $chariton_breadcrumb_text_transform;
		    } else {
		      $chariton_breadcrumb_text_transform = 'capitalize';
		    }

		    $chariton_breadcrumb_font_size = chariton_get_option( 'chariton_breadcrumb_font_size' );
		    if (!empty($chariton_breadcrumb_font_size)) {
		      $chariton_breadcrumb_font_size = $chariton_breadcrumb_font_size;
		    } else {
		      $chariton_breadcrumb_font_size = '80px';
		    }
		    
		    $breadcrumb_overlay_color = chariton_get_option( 'breadcrumb_overlay_color' );
		    if (!empty($breadcrumb_overlay_color)) {
		      $breadcrumb_overlay_color = $breadcrumb_overlay_color;
		    } else {
		      $breadcrumb_overlay_color = '#000927';
		    }
		   	
		    $breadcrumb_bg_img_opacity = chariton_get_option( 'breadcrumb_bg_img_opacity' );
		    if (!empty($breadcrumb_bg_img_opacity)) {
		      $breadcrumb_bg_img_opacity = $breadcrumb_bg_img_opacity;
		    } else {
		      $breadcrumb_bg_img_opacity = '.7';
		    }

		    $page_breadcrumb_color_data = get_post_meta( get_the_ID(), '_custom_page_breadcrumb_options', true );

		    if (!empty($page_breadcrumb_color_data['page_breadcrumb_switch'])) {
		        if (!empty($page_breadcrumb_color_data['breadcrumb_bg_color'])) {
		          $breadcrumb_overlay_color = $page_breadcrumb_color_data['breadcrumb_bg_color'];
		        } else {
		          $breadcrumb_overlay_color = $breadcrumb_overlay_color;
		        }
		        if (!empty($page_breadcrumb_color_data['breadcrumb_bg_img_opacity'])) {
		          $breadcrumb_bg_img_opacity = $page_breadcrumb_color_data['breadcrumb_bg_img_opacity'];
		        } else {
		          $breadcrumb_bg_img_opacity = $breadcrumb_bg_img_opacity;
		        }
		        if (!empty($page_breadcrumb_color_data['breatcrumb_pt'])) {
		          $breatcrumb_pt = $page_breadcrumb_color_data['breatcrumb_pt'];
		        } else {
		          $breatcrumb_pt = $breatcrumb_pt;
		        }
		        if (!empty($page_breadcrumb_color_data['breatcrumb_pb'])) {
		          $breatcrumb_pb = $page_breadcrumb_color_data['breatcrumb_pb'];
		        } else {
		          $breatcrumb_pb = $breatcrumb_pb;
		        }
		        if (!empty($page_breadcrumb_color_data['breatcrumb_font_color'])) {
		          $breatcrumb_font_color = $page_breadcrumb_color_data['breatcrumb_font_color'];
		        } else {
		          $breatcrumb_font_color = $breatcrumb_font_color;
		        }
		        if (!empty($page_breadcrumb_color_data['breatcrumb_hover_link_color'])) {
		          $breatcrumb_hover_link_color = $page_breadcrumb_color_data['breatcrumb_hover_link_color'];
		        } else {
		          $breatcrumb_hover_link_color = $breatcrumb_hover_link_color;
		        }
		    } else {
		        $breatcrumb_pt = $breatcrumb_pt;
		        $breatcrumb_pb = $breatcrumb_pb;
		        $breatcrumb_font_color = $breatcrumb_font_color;
		        $breadcrumb_overlay_color = $breadcrumb_overlay_color;
		        $breadcrumb_bg_img_opacity = $breadcrumb_bg_img_opacity;
		        $breatcrumb_hover_link_color = $breatcrumb_hover_link_color;
		    }

		    $bread_oc = get_post_meta( get_the_ID(), '_custom_page_breadcrumb_options', true );
		    if (!empty($bread_oc['page_breadcrumb_overlay_color'])) {
		    	$breadcrumb_overlay_color = $bread_oc['page_breadcrumb_overlay_color'];
		    } else {
		    	$breadcrumb_overlay_color = $breadcrumb_overlay_color;
		    }


		    if ( $breadcrumb_bg_condition != 'image' ) {
		      $breadcrumb_area = ".breadcrumb-area {
		        padding-top: $breatcrumb_pt !important;
		        padding-bottom: $breatcrumb_pb !important;
		        background: $breadcrumb_bg_color;
		      }";
		    } else {
		       $breadcrumb_area = ".breadcrumb-area {
		        padding-top: $breatcrumb_pt;
		        padding-bottom: $breatcrumb_pb;
		      }";
		    }

		    // Header 2
		    $default_h2_top = chariton_get_option( 'default_h2_top' );
		    if (!empty($default_h2_top)) {
		      $default_h2_top = $default_h2_top;
		    } else {
		      $default_h2_top = '290px';
		    }
		    $default_h2_bottom = chariton_get_option( 'default_h2_bottom' );
		    if (!empty($default_h2_bottom)) {
		      $default_h2_bottom = $default_h2_bottom;
		    } else {
		      $default_h2_bottom = '135px';
		    }
		    // Header 3
		    $default_h3_top = chariton_get_option( 'default_h3_top' );
		    if (!empty($default_h3_top)) {
		      $default_h3_top = $default_h3_top;
		    } else {
		      $default_h3_top = '325px';
		    }
		    $default_h3_bottom = chariton_get_option( 'default_h3_bottom' );
		    if (!empty($default_h3_bottom)) {
		      $default_h3_bottom = $default_h3_bottom;
		    } else {
		      $default_h3_bottom = '135px';
		    }

		    echo "<style>
				/* = Breadcrumb Color = */
				$breadcrumb_area
				.breadcrumb-area.breadcrumb_height .breadcrumb-item + .breadcrumb-item::before,
				.breadcrumb-area.breadcrumb_height .breadcrumb-wrap h2,
				.breadcrumb-area.breadcrumb_height .breadcrumb li a, 
				.breadcrumb-area.breadcrumb_height .breadcrumb li,
				.breadcrumb-area.breadcrumb_height .bread_crumb .breadcrumbs-title,
				.breadcrumb-area.breadcrumb_height .bread_crumb .breadcrumbs-title a,
				.breadcrumb-item + .breadcrumb-item::before {
					color: $breatcrumb_font_color;
				}
				.image-overlay:before {
				opacity: $breadcrumb_bg_img_opacity;
					background-color: $breadcrumb_overlay_color;
				}
				.breadcrumb-area.breadcrumb_height .bread_crumb .breadcrumbs-title a:hover,
				.breadcrumb li a:hover {
					color: $breatcrumb_hover_link_color !important;
				}
				.breadcrumb_height.hv2 {
			        padding-top: $default_h2_top !important;
			        padding-bottom: $default_h2_bottom !important;
			    }
				.breadcrumb_height.hv3 {
			        padding-top: $default_h3_top !important;
			        padding-bottom: $default_h3_bottom !important;
			    }
			    .breadcrumb-wrap h2 {
			    	font-size: $chariton_breadcrumb_font_size !important;
			    	font-weight: $chariton_breadcrumb_font_weight !important;
			    	text-transform: $chariton_breadcrumb_text_transform !important;
			    }
		    </style>";

  		}		
	}
	
} // end class

$GLOBALS['chariton_master_core'] = new Chariton_Master_Core;

function chariton_master_global_var(){
	global $chariton_master_core;
	return $chariton_master_core;
}