<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

if(!function_exists('goodheart_setup_metaboxes')){
	function goodheart_setup_metaboxes(){
		if(!function_exists('lastudio_kit_post_meta')){
			return;
		}
		lastudio_kit_post_meta()->add_options( array (
			'id'            => 'goodheart-portfolio-settings',
			'title'         => esc_html__( 'Portfolio Settings', 'goodheart' ),
			'page'          => array( 'la_portfolio' ),
			'context'       => 'normal',
			'priority'      => 'high',
			'callback_args' => false,
			'fields'        => array(
                '_la_bg' => array(
                    'type'               => 'media',
                    'title'              => esc_html__( 'Background Image', 'goodheart' ),
                    'description'        => esc_html__( 'This option will work on some cases.', 'goodheart' ),
                    'library_type'       => 'image',
                    'multi_upload'       => false,
                    'value_format'       => 'id',
                    'upload_button_text' => esc_html__( 'Set Image', 'goodheart' ),
                ),
				'_pf_gallery' => array(
					'type'               => 'media',
					'title'              => esc_html__( 'Image Gallery', 'goodheart' ),
					'description'        => esc_html__( 'Choose image(s) for the gallery. This setting is used for your gallery.', 'goodheart' ),
					'library_type'       => 'image',
					'upload_button_text' => esc_html__( 'Set Gallery Images', 'goodheart' ),
				),
				'_pf_description' => array(
					'type'        => 'wysiwyg',
					'title'       => esc_html__( 'Short Description', 'goodheart' ),
					'rows'        => 5
				),
				'_pf_client' => array(
					'type'        => 'text',
					'title'       => esc_html__( 'Client', 'goodheart' ),
				),
				'_pf_date' => array(
					'type'        => 'text',
					'title'       => esc_html__( 'Date', 'goodheart' ),
				),
                '_pf_location' => array(
					'type'        => 'text',
					'title'       => esc_html__( 'Location', 'goodheart' ),
				),
                '_pf_designer' => array(
					'type'        => 'text',
					'title'       => esc_html__( 'Designer', 'goodheart' ),
				),
				'_pf_awards' => array(
					'type'        => 'text',
					'title'       => esc_html__( 'Awards', 'goodheart' ),
				),
				'_pf_link1' => array(
					'type'        => 'text',
					'title'       => esc_html__( 'Demo Link 1', 'goodheart' ),
				),
				'_pf_link2' => array(
					'type'        => 'text',
					'title'       => esc_html__( 'Demo Link 2', 'goodheart' ),
				),
			),
		) );

		lastudio_kit_post_meta()->add_options( array (
			'id'            => 'goodheart-post-settings',
			'title'         => esc_html__( 'Post Settings', 'goodheart' ),
			'page'          => array( 'post' ),
			'context'       => 'normal',
			'priority'      => 'high',
			'callback_args' => false,
			'fields'        => array(
				'_la_bg' => array(
					'type'               => 'media',
					'title'              => esc_html__( 'Background Image', 'goodheart' ),
					'description'        => esc_html__( 'This option will work on some cases.', 'goodheart' ),
					'library_type'       => 'image',
					'multi_upload'       => false,
					'value_format'       => 'id',
					'upload_button_text' => esc_html__( 'Set Image', 'goodheart' ),
				),
				'post_formats' => array(
					'type' => 'component-tab-horizontal',
					'ignore_save'   => true,
				),
				'gallery_tab' => array(
					'type'      => 'settings',
					'ignore_save'   => true,
					'parent'    => 'post_formats',
					'title'     => esc_html__( 'Gallery', 'goodheart' ),
				),
				'_la_gallery_images' => array(
					'type'               => 'media',
					'parent'             => 'gallery_tab',
					'title'              => esc_html__( 'Image Gallery', 'goodheart' ),
					'description'        => esc_html__( 'Choose image(s) for the gallery. This setting is used for your gallery post formats.', 'goodheart' ),
					'library_type'       => 'image',
					'multi_upload'       => true,
					'value_format'       => 'id',
					'upload_button_text' => esc_html__( 'Set Gallery Images', 'goodheart' ),
				),
				'link_tab' => array(
					'type'      => 'settings',
					'ignore_save'   => true,
					'parent'    => 'post_formats',
					'title'     => esc_html__( 'Link', 'goodheart' ),
				),
				'_la_link_text' => array(
					'type'        => 'text',
					'parent'      => 'link_tab',
					'title'       => esc_html__( 'Link Text', 'goodheart' ),
					'description' => esc_html__( 'Enter your text. This setting is used for your link post formats.', 'goodheart' ),
				),
				'_la_link' => array(
					'type'        => 'text',
					'parent'      => 'link_tab',
					'title'       => esc_html__( 'Link URL', 'goodheart' ),
					'description' => esc_html__( 'Enter your external url. This setting is used for your link post formats.', 'goodheart' ),
				),
				'_la_link_target' => array(
					'type'        => 'select',
					'parent'      => 'link_tab',
					'title'       => esc_html__( 'Link Target', 'goodheart' ),
					'description' => esc_html__( 'Choose your target for the url. This setting is used for your link post formats.', 'goodheart' ),
					'value'       => '_blank',
					'options'     => array(
						'_blank' => esc_html__('Blank', 'goodheart'),
						'_self'  => esc_html__('Self', 'goodheart'),
					),
				),
				'quote_tab' => array(
					'type'      => 'settings',
					'ignore_save'   => true,
					'parent'    => 'post_formats',
					'title'     => esc_html__( 'Quote', 'goodheart' ),
				),
				'_la_quote_text' => array(
					'type'        => 'textarea',
					'parent'      => 'quote_tab',
					'title'       => esc_html__( 'Quote', 'goodheart' ),
					'description' => esc_html__( 'Enter your quote. This setting is used for your quote post formats.', 'goodheart' ),
				),
				'_la_quote_cite' => array(
					'type'        => 'text',
					'parent'      => 'quote_tab',
					'title'       => esc_html__( 'Cite', 'goodheart' ),
					'description' => esc_html__( 'Enter the quote source. This setting is used for your quote post formats.', 'goodheart' ),
				),
				'_la_quote_color' => array(
					'type'        => 'colorpicker',
					'parent'      => 'quote_tab',
					'title'       => esc_html__( 'Text Color', 'goodheart' ),
				),
				'_la_quote_bg' => array(
					'type'        => 'colorpicker',
					'parent'      => 'quote_tab',
					'title'       => esc_html__( 'Background Color', 'goodheart' ),
				),
				'video_audio_tab' => array(
					'type'      => 'settings',
					'ignore_save'   => true,
					'parent'    => 'post_formats',
					'title'     => esc_html__( 'Video & Audio', 'goodheart' ),
				),
				'_la_video_link' => array(
					'type'        => 'text',
					'parent'      => 'video_audio_tab',
					'title'       => esc_html__( 'Link Video URL', 'goodheart' ),
					'description' => esc_html__( 'Insert Youtube or Vimeo video link', 'goodheart' ),
				),
			),
		) );
	}
}

add_action( 'after_setup_theme', 'goodheart_setup_metaboxes', 6 );
