<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package GoodHeart
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<main class="site-main" role="main">
  <div class="default-404-content">
      <div class="default-404-content-container">
          <div class="container">
              <div class="lakit-row">
                  <div class="lakit-col default-404-content--content">
                      <div class="default-404-content--inner">
                          <h2><?php echo esc_html_x('404', 'front-end', 'goodheart') ?></h2>
                          <h4><?php echo esc_html_x('Ooops, page not found', 'front-end', 'goodheart') ?></h4>
                          <p><?php echo esc_html_x("Sorry, but the requested page is not found.", 'front-end', 'goodheart'); ?></p>
                          <div class="button-wrapper"><a class="button" href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html_x('Back to homepage', 'front-view','goodheart')?></a></div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</main>
