<?php
/**
 * Template Name: GoodHeart Full Width
 * Template Post Type: post, page, product, la_portfolio, la_event, la_album, give_forms
 *
 * This is the most generic template file in a WordPress theme and one of the
 * two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * Learn more: https://codex.wordpress.org/Template_Hierarchy
 *
 * @package GoodHeart WordPress theme
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
get_header();

if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'single' ) ) {

	$settings = get_post_meta(get_the_ID(), '_elementor_page_settings', true);
	$editor_mode = get_post_meta(get_the_ID(), '_elementor_edit_mode', true);
	$show_title = ! ( !empty( $settings['hide_title'] ) && $settings['hide_title'] == 'yes' );

	if ($show_title && apply_filters('goodheart/filter/enable_page_title', true)){
		the_title('<div class="page-header page-header--default"><div class="container page-header-inner"><h1 class="entry-title">', '</h1></div></div>');
	}
	if($editor_mode !== 'builder'){
		echo '<div class="container site-content--default">';
	}
	the_content();
	if($editor_mode !== 'builder') {
		echo '</div>';
	}

}

get_footer();